/*
 * Decompiled with CFR 0.152.
 */
package ttrace.handlers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import ttrace.handlers.Environment;
import ttrace.handlers.OSValidator;
import ttrace.handlers.SDBconnection;

class ThreadBootupTracing
implements Runnable {
    Display display = Display.getCurrent();
    Shell shell = new Shell(this.display);
    Button mainButton = null;

    ThreadBootupTracing(Button button) {
        this.mainButton = button;
    }

    public void composeHtml(String strCmd) throws IOException {
        System.out.println("Compose: " + strCmd);
        try {
            if (!OSValidator.isWindows()) {
                Runtime.getRuntime().exec(strCmd);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void bootupStart() {
        Environment env = Environment.getInstance();
        String strCmd = new String(env.getBootupCmd());
        System.out.println("bootupStart::ThreadBootupTracing: " + strCmd);
        try {
            FileWriter fos = new FileWriter(String.valueOf(env.getTracePath()) + env.getBootupConf());
            BufferedWriter bos = new BufferedWriter(fos);
            bos.write(String.valueOf(strCmd) + '\n');
            bos.close();
            fos.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        strCmd = new String(String.valueOf(SDBconnection.getSDBpath()) + " push " + env.getTracePath() + env.getBootupConf() + " /etc/ttrace.conf");
        try {
            Runtime.getRuntime().exec(strCmd);
        }
        catch (IOException e) {
            System.out.println("BootupStart:::::EXCEPTION!!!!");
            e.printStackTrace();
        }
        strCmd = new String(String.valueOf(SDBconnection.getSDBpath()) + " shell reboot");
        try {
            Runtime.getRuntime().exec(strCmd);
        }
        catch (IOException e) {
            System.out.println("BootupStart:::::REBOOT!!!!");
            e.printStackTrace();
        }
    }

    public void asyncCommand(String strCmd) throws IOException {
        int iter = 0;
        Environment env = Environment.getInstance();
        Process p = null;
        BufferedInputStream in = null;
        FileOutputStream fos = new FileOutputStream(String.valueOf(env.getTracePath()) + env.getBootupTrace());
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        try {
            try {
                p = Runtime.getRuntime().exec(strCmd);
                in = new BufferedInputStream(p.getInputStream());
                while ((iter = in.read()) != -1) {
                    bos.write(iter);
                    bos.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                bos.close();
            }
        }
        finally {
            bos.close();
        }
    }

    @Override
    public void run() {
        this.bootupStart();
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)ThreadBootupTracing.this.shell, (String)"Instruction", (String)"Please pull out the usb cable during rebooting the target");
                ThreadBootupTracing.this.mainButton.setText("Waiting for reboot");
                ThreadBootupTracing.this.mainButton.setEnabled(false);
            }
        });
        int i = 0;
        while (i < 3) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)ThreadBootupTracing.this.shell, (String)"Instruction", (String)"Please connect the usb cable what if reboot is completed");
                ThreadBootupTracing.this.mainButton.setText("Waiting for connection");
                ThreadBootupTracing.this.mainButton.setEnabled(false);
            }
        });
        while (SDBconnection.getState() != "Connected") {
            try {
                Thread.sleep(2500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ThreadBootupTracing.this.mainButton.setText("Waiting for connecting");
                    ThreadBootupTracing.this.mainButton.setEnabled(false);
                }
            });
        }
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ThreadBootupTracing.this.mainButton.setText("Stop");
                ThreadBootupTracing.this.mainButton.setEnabled(true);
            }
        });
        System.out.println("Bootup Thread died");
    }
}

