/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sensor.axis.gui;

public class Vector {
    public double x;
    public double y;
    public double z;
    private static double[] axisX = new double[]{1.0, 0.0, 0.0};
    private static double[] axisY = new double[]{0.0, 0.0, 1.0};
    private static double[] axisZ = new double[]{0.0, -1.0, 0.0};
    static Vector obj = new Vector();

    public Vector() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vector(Vector vector) {
        this.x = vector.x;
        this.y = vector.y;
        this.z = vector.z;
    }

    public Vector(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public void scale(double d) {
        this.x = d * this.x;
        this.y = d * this.y;
        this.z = d * this.z;
    }

    public void yaw(double d) {
        Vector vector = new Vector(this);
        double d2 = Math.toRadians(d);
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        this.x = d3 * vector.x + d4 * vector.y;
        this.y = -d4 * vector.x + d3 * vector.y;
        this.z = vector.z;
    }

    public void pitch(double d) {
        Vector vector = new Vector(this);
        double d2 = Math.toRadians(d);
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        this.x = vector.x;
        this.y = d3 * vector.y + d4 * vector.z;
        this.z = -d4 * vector.y + d3 * vector.z;
    }

    public void roll(double d) {
        Vector vector = new Vector(this);
        double d2 = Math.toRadians(d);
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        this.x = d3 * vector.x + d4 * vector.z;
        this.y = vector.y;
        this.z = -d4 * vector.x + d3 * vector.z;
    }

    public static double[] getAxisX() {
        return axisX;
    }

    public static double[] getAxisY() {
        return axisY;
    }

    public static double[] getAxisZ() {
        return axisZ;
    }

    public void setAxisX(double[] dArray) {
        Vector.axisX[0] = dArray[0];
        Vector.axisX[1] = dArray[1];
        Vector.axisX[2] = dArray[2];
    }

    public void setAxisY(double[] dArray) {
        Vector.axisY[0] = dArray[0];
        Vector.axisY[1] = dArray[1];
        Vector.axisY[2] = dArray[2];
    }

    public void setAxisZ(double[] dArray) {
        Vector.axisZ[0] = dArray[0];
        Vector.axisZ[1] = dArray[1];
        Vector.axisZ[2] = dArray[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[][] getRotationMatrix() {
        Vector vector = obj;
        synchronized (vector) {
            double[][] dArrayArray = new double[][]{{axisX[0], axisX[1], axisX[2], 0.0}, {axisY[0], axisY[1], axisY[2], 0.0}, {axisZ[0], axisZ[1], axisZ[2], 0.0}, {0.0, 0.0, 0.0, 1.0}};
            return dArrayArray;
        }
    }

    public double[][] getReverseMatrix(double[][] dArray) {
        double[][] dArray2 = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                dArray2[i][j] = dArray[j][i];
            }
        }
        return dArray2;
    }

    public void changeAxisRoll(double d, double[] dArray, double[] dArray2) {
        double[][] dArray3 = this.getRotationMatrix();
        double[][] dArray4 = this.getReverseMatrix(dArray3);
        double d2 = Math.toRadians(d);
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        dArray[0] = d3 * 1.0 + d4 * 0.0;
        dArray[1] = 0.0;
        dArray[2] = -d4 * 1.0 + d3 * 0.0;
        this.trasnAxis(dArray, dArray4);
        dArray2[0] = d3 * 0.0 + d4 * 1.0;
        dArray2[1] = 0.0;
        dArray2[2] = -d4 * 0.0 + d3 * 1.0;
        this.trasnAxis(dArray2, dArray4);
    }

    public void changeAxisPitch(double d, double[] dArray, double[] dArray2) {
        double[][] dArray3 = this.getRotationMatrix();
        double[][] dArray4 = this.getReverseMatrix(dArray3);
        double d2 = Math.toRadians(d);
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        dArray[0] = 0.0;
        dArray[1] = d3 * 1.0 + d4 * 0.0;
        dArray[2] = -d4 * 1.0 + d3 * 0.0;
        this.trasnAxis(dArray, dArray4);
        dArray2[0] = 0.0;
        dArray2[1] = d3 * 0.0 + d4 * 1.0;
        dArray2[2] = -d4 * 0.0 + d3 * 1.0;
        this.trasnAxis(dArray2, dArray4);
    }

    public void changeAxisYaw(double d, double[] dArray, double[] dArray2) {
        double[][] dArray3 = this.getRotationMatrix();
        double[][] dArray4 = this.getReverseMatrix(dArray3);
        double d2 = Math.toRadians(d);
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        dArray[0] = d3 * 1.0 + d4 * 0.0;
        dArray[1] = -d4 * 1.0 + d3 * 0.0;
        dArray[2] = 0.0;
        this.trasnAxis(dArray, dArray4);
        dArray2[0] = d3 * 0.0 + d4 * 1.0;
        dArray2[1] = -d4 * 0.0 + d3 * 1.0;
        dArray2[2] = 0.0;
        this.trasnAxis(dArray2, dArray4);
    }

    public void trasnAxis(double[] dArray, double[][] dArray2) {
        double[] dArray3 = new double[]{0.0, 0.0, 0.0, 0.0};
        for (int i = 0; i < 4; ++i) {
            dArray3[i] = dArray2[i][0] * dArray[0] + dArray2[i][1] * dArray[1] + dArray2[i][2] * dArray[2];
        }
        dArray[0] = dArray3[0];
        dArray[1] = dArray3[1];
        dArray[2] = dArray3[2];
    }

    public void transVector(double[][] dArray) {
        double[] dArray2 = new double[]{0.0, 0.0, 0.0, 0.0};
        for (int i = 0; i < 4; ++i) {
            dArray2[i] = dArray[i][0] * this.x + dArray[i][1] * this.y + dArray[i][2] * this.z;
        }
        this.x = dArray2[0];
        this.y = dArray2[1];
        this.z = dArray2[2];
    }

    public void setPosition() {
        double[][] dArray = this.getRotationMatrix();
        double[][] dArray2 = this.getReverseMatrix(dArray);
        this.transVector(dArray2);
    }

    public void rollpitchyaw(double d, double d2, double d3) {
        this.changeAxisRoll(d, axisX, axisZ);
        this.changeAxisPitch(d2, axisY, axisZ);
        this.changeAxisYaw(d3, axisX, axisY);
    }

    public void reverserollpitchyaw() {
        double[][] dArray = this.getRotationMatrix();
        this.transVector(dArray);
    }
}

