/* EINA - EFL data type library
 * Copyright (C) 2008 Cedric Bail
 *
 * This library is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library;
 * if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef EINA_HAMSTER_H_
#define EINA_HAMSTER_H_

/**
 * @internal
 * @defgroup Eina_Hamster_Group Hamster
 * @ingroup Eina_Core_Group
 *
 * @brief This group discusses the functions that provide hamster calls.
 *
 * @{
 */


/**
 * @brief Gets the hamster count.
 *
 * @if MOBILE @since_tizen 2.3
 * @elseif WEARABLE @since_tizen 2.3.1
 * @endif
 *
 * @details This function returns the number of hamsters that are available.
 *
 * @return The number of available hamsters
 */
//EAPI int eina_hamster_count(void);

/**
 * @}
 */

#endif /* EINA_HAMSTER_H_ */
