/*******************************************************************************
 * Copyright (c) 2008, 2013 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

/***************************** <<NonElementParentNode>> *************************************/
/**
 * Object NonElementParentNode()
 * https://www.w3.org/TR/domcore/#interface-nonelementparentnode
 *
 * @arguments Object
 * @constructor
 * @since Level 4 Document Object Model Core Definition.
 * @see Object
 */
function NonElementParentNode(){};
NonElementParentNode.prototype = new Object();
/**
 * function getElementById(elementId)
 * https://www.w3.org/TR/domcore/#interface-nonelementparentnode
 *
 * @param {String} elementId
 * @return {Node}
 * @since Level 4 Document Object Model Core Definition.
 * @see NonElementParentNode
 */
NonElementParentNode.prototype.getElementById = function(elementId){return new Node();};

/********************************** <<ParentNode>> *****************************************/
/**
 * Object ParentNode()
 * https://www.w3.org/TR/domcore/#interface-parentnode
 *
 * @arguments Object
 * @constructor
 * @since Level 4 Document Object Model Core Definition.
 * @see Object
 */
function ParentNode(){};
ParentNode.prototype = new Object();
/**
 * Property children 
 * https://www.w3.org/TR/domcore/#interface-parentnode
 *
 * @type HTMLCollection
 * @since Level 4 Document Object Model Core Definition.
 * @see ParentNode
 */
ParentNode.prototype.children = new HTMLCollection();
/**
 * Property firstElementChild 
 * https://www.w3.org/TR/domcore/#interface-parentnode
 *
 * @type Node
 * @since Level 4 Document Object Model Core Definition.
 * @see ParentNode
 */
ParentNode.prototype.firstElementChild = new node();
/**
 * Property lastElementChild 
 * https://www.w3.org/TR/domcore/#interface-parentnode
 *
 * @type Node
 * @since Level 4 Document Object Model Core Definition.
 * @see ParentNode
 */
ParentNode.prototype.lastElementChild = new node();
/**
 * Property chileElementCount 
 * https://www.w3.org/TR/domcore/#interface-parentnode
 *
 * @type Number
 * @since Level 4 Document Object Model Core Definition.
 * @see ParentNode
 */
ParentNode.prototype.lastElementChild = 0;

/*************************** <<NonDocumentTypeChildNode>> **********************************/
/**
 * Object NonDocumentTypeChildNode()
 * https://www.w3.org/TR/domcore/#interface-nondocumenttypechildnode
 * 
 * @arguments Object
 * @constructor
 * @since Level 4 Document Object Model Core Definition.
 * @see Object
 */
function NonDocumentTypeChildNode(){};
NonDocumentTypeChildNode.prototype = new Object();
/**
 * Property previousElementSibling 
 * https://www.w3.org/TR/domcore/#interface-nondocumenttypechildnode
 *
 * @type Node
 * @since Level 4 Document Object Model Core Definition.
 * @see NonDocumentTypeChildNode
 */
NonDocumentTypeChildNode.prototype.previouseElementSibling = new Node();
/**
 * Property nextElementSibling
 * https://www.w3.org/TR/domcore/#interface-nondocumenttypechildnode
 *
 * @type Node
 * @since Level 4 Document Object Model Core Definition.
 * @see NonDocumentTypeChildNode
 */
NonDocumentTypeChildNode.prototype.nextElementSibling = new Node();

/*********************************** <<ChildNode>> *****************************************/
/**
 * Object ChildNode()
 * https://www.w3.org/TR/domcore/#childnode
 * 
 * @arguments Object
 * @constructor
 * @since Level 4 Document Object Model Core Definition.
 * @see Object
 */
function ChildNode(){};
ChildNode.prototype = new Object();
/**
 * function remove
 * https://www.w3.org/TR/domcore/#interface-nonelementparentnode
 *
 * @param None
 * @return None
 * @since Level 4 Document Object Model Core Definition.
 * @see NonElementParentNode
 */
ChildNode.prototype.remove = function(){return;};

/*********************************** <<NodeList>> ******************************************/
/**
 * Object NodeList()
 * https://www.w3.org/TR/domcore/#nodelist
 * 
 * @arguments Object
 * @constructor
 * @since Level 4 Document Object Model Core Definition.
 * @see Object
 */
function NodeList(){};
NodeList.prototype = new Object();
/**
 * Property length   
 * https://www.w3.org/TR/domcore/#nodelist
 * 
 * @type Number
 * @since Level 4 Document Object Model Core Definition.  
 */ 
NodeList.prototype.length=0; 
/**
 * function item(index) 
 * https://www.w3.org/TR/domcore/#nodelist 
 *     Note: This object can also be dereferenced using square bracket notation (e.g. obj[1]). Dereferencing with an integer index is equivalent to invoking the item method with that index 
 * 
 * @param {Number} index
 * @returns {Node}
 * @since Level 4 Document Object Model Core Definition.
 * @see Node     
*/ 
NodeList.prototype.item = function(index){return new Node();}; 

/********************************** HTMLCollection *****************************************/
/**
 * Object HTMLCollection()
 * https://www.w3.org/TR/domcore/#htmlcollection
 * 
 * @arguments Object
 * @constructor
 * @since Level 4 Document Object Model HTML Specification.
 */ 
function HTMLCollection(){};
HTMLCollection.prototype = new Object();
/**
 * Property length
 * https://www.w3.org/TR/domcore/#htmlcollection
 * 
 * @type Number
 * @since Level 4 Document Object Model HTML Specification.
 */
HTMLCollection.prototype.length=0;
/**
 * function item(index)
 * https://www.w3.org/TR/domcore/#htmlcollection
 * 
 * @param {Number} index
 * @returns {Node}
 * @since Level 4 Document Object Model HTML Specification.
 */
HTMLCollection.prototype.item = function(index){return new Node();};
/**
 * function namedItem(name)
 * https://www.w3.org/TR/domcore/#htmlcollection
 * 
 * @param {String} name
 * @returns {Node}
 * @since Level 4 Document Object Model HTML Specification.
 */
HTMLCollection.prototype.namedItem = function(index){return new Node();};

/************************************* Node ********************************************/
/**
 * Object Node()
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @arguments Object
 * @constructor
 * @memberOf Node
 * @since Level 4 Document Object Model Core Definition.
 * @see EventTarget    
 */
function Node(){};
Node.prototype=new EventTarget(); 
/**
 * Constant Node.ELEMENT_NODE=1
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @constant
 * @type Number
 * @since Level 4 Document Object Model Core Definition.   
 */
Node.ELEMENT_NODE=1; 
/**
 * Constant Node.ATTRIBUTE_NODE=2
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @constant
 * @type Number
 * @since Level 4 Document Object Model Core Definition.   
 */
Node.ATTRIBUTE_NODE=2;
/**
 * Constant Node.TEXT_NODE=3
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @constant
 * @type Number
 * @since Level 4 Document Object Model Core Definition.   
 */
Node.TEXT_NODE=3;
/**
 * Constant Node.CDATA_SECTION_NODE=4
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @constant
 * @type Number
 * @since Level 4 Document Object Model Core Definition.   
 */
Node.CDATA_SECTION_NODE=4; 
/**
 * Constant Node.ENTITY_REFERENCE_NODE=5
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @constant
 * @type Number
 * @since Level 4 Document Object Model Core Definition.   
 */
Node.ENTITY_REFERENCE_NODE=5; 
/**
 * Constant Node.ENTITY_NODE=6
 * https://www.w3.org/TR/domcore/#interface-node
 *
 * @constant
 * @type Number
 * @since Level 4 Document Object Model Core Definition.
 */
Node.ENTITY_NODE=6;
/**
 * Constant Node.PROCESSING_INSTRUCTION_NODE=7
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @constant
 * @type Number
 * @since Level 4 Document Object Model Core Definition.   
 */
Node.PROCESSING_INSTRUCTION_NODE=7; 
/**
 * Constant Node.COMMENT_NODE=8
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @constant
 * @type Number
 * @since Level 4 Document Object Model Core Definition.   
 */
Node.COMMENT_NODE=8;
/**
 * Constant Node.DOCUMENT_NODE=9
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @constant
 * @type Number
 * @since Level 4 Document Object Model Core Definition.   
 */
Node.DOCUMENT_NODE=9;
/**
 * Constant Node.DOCUMENT_TYPE_NODE=10
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @constant
 * @type Number
 * @since Level 4 Document Object Model Core Definition.   
 */
Node.DOCUMENT_TYPE_NODE=10; 
/**
 * Constant Node.DOCUMENT_FRAGMENT_NODE=11
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @constant
 * @type Number
 * @since Level 2 Document Object Model Core Definition.   
 */
Node.DOCUMENT_FRAGMENT_NODE=11; 
/**
 * Constant Node.NOTATION_NODE=12
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @constant
 * @type Number
 * @since Level 2 Document Object Model Core Definition.   
 */
Node.NOTATION_NODE=12;

/**
 * Property nodeType
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @type Number
 * @since Level 4 Document Object Model Core Definition.    
 */  
Node.prototype.nodeType = 0; 
/**
 * Property nodeName
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @type String
 * @since Standard ECMA-262 3rd. Edition 
 * @since Level 4 Document Object Model Core Definition.  
 */ 
Node.prototype.nodeName = ""; 
/**
 * Property parentNode 
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @type Node
 * @since Level 4 Document Object Model Core Definition.
 * @see Node    
 */
Node.prototype.parentNode=new Node();
/**
 * Property childNodes 
 * https://www.w3.org/TR/domcore/#interface-node
 *  
 * @type NodeList
 * @since Level 4 Document Object Model Core Definition.
 * @see NodeList    
*/ 
Node.prototype.childNodes=new NodeList();
/**
 * Property firstChild 
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @type Node
 * @since Level 4 Document Object Model Core Definition.
 * @see Node    
 */  
Node.prototype.firstChild=new Node(); 
/**
 * Property lastChild 
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @type Node
 * @since Level 4 Document Object Model Core Definition.
 * @see Node    
 */  
Node.prototype.lastChild=new Node();
/**
 * Property previousSibling 
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @type Node
 * @since Level 4 Document Object Model Core Definition.
 * @see Node    
 */  
Node.prototype.previousSibling=new Node(); 
/**
 * Property nextSibling  
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @type Node
 * @since Level 4 Document Object Model Core Definition.
 * @see Node    
 */  
Node.prototype.nextSibling=new Node(); 
/**
 * Property nodeValue
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @type String
 * @throws DOMException
 * @since Level 4 Document Object Model Core Definition.    
 */ 
Node.prototype.nodeValue = ""; 
/**
 * Property textContent
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @type String
 * @throws DOMException
 * @since Level 4 Document Object Model Core Definition.    
 */ 
Node.prototype.textContent = ""; 

/**
 * function hasChildNodes() 
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @returns {Boolean}
 * @since Level 4 Document Object Model Core Definition.  
 */ 
Node.prototype.hasChildNodes=function(){return false;}; 
/**
 * function cloneNode(deep) 
 * https://www.w3.org/TR/domcore/#interface-node
 *   
 * @param {Boolean} deep
 * @returns {Node}
 * @since Level 4 Document Object Model Core Definition.
 * @see Node  
 */ 
Node.prototype.cloneNode=function(deep){return new Node();}; 
/**
 * function isEqualNode(other) 
 * https://www.w3.org/TR/domcore/#interface-node
 *   
 * @param {Node} 
 * @returns {Boolean}
 * @since Level 4 Document Object Model Core Definition.
 * @see Node  
 */
Node.prototype.isEqualNode=function(other){return false;};
/**
 * function compareDocumentPosition
 * https://www.w3.org/TR/domcore/#interface-node
 *   
 * @param {Node} 
 * @returns {Number}
 * @since Level 4 Document Object Model Core Definition.
 * @see Node  
 */
Node.prototype.compareDocumentPosition=function(other){return 0;};
/**
 * function contains
 * https://www.w3.org/TR/domcore/#interface-node
 *   
 * @param {Node} 
 * @returns {Boolean}
 * @since Level 4 Document Object Model Core Definition.
 * @see Node  
 */
Node.prototype.contains=function(other){return false;};
/**
 * function insertBefore(node, child) 
 * https://www.w3.org/TR/domcore/#interface-node
 * 
 * @param {Node} node
 * @param {Node} child
 * @returns {Node}
 * @throws DOMException
 * @since Level 4 Document Object Model Core Definition.
 * @see Node  
 */  
Node.prototype.insertBefore = function(node, child){return new Node();}; 
/**
 * function appendChild(node) 
 * https://www.w3.org/TR/domcore/#interface-node
 *   
 * @param {Node} node
 * @returns {Node}
 * @throws DOMException
 * @since Level 4 Document Object Model Core Definition.
 * @see Node  
 */  
Node.prototype.appendChild = function(node){return new Node();}; 
/**
 * function replaceChild(node, child) 
 * https://www.w3.org/TR/domcore/#interface-node
 *   
 * @param {Node} node
 * @param {Node} child
 * @returns {Node}
 * @throws DOMException
 * @since Level 4 Document Object Model Core Definition.
 * @see Node  
 */ 
Node.prototype.replaceChild = function(node, child){return new Node();}; 
/**
 * function removeChild(child) 
 * https://www.w3.org/TR/domcore/#interface-node
 *   
 * @param {Node} child
 * @returns {Node}
 * @throws DOMException
 * @since Level 4 Document Object Model Core Definition.
 * @see Node  
 */ 
Node.prototype.removeChild = function(child){return new Node();}; 

/************************************* Document ********************************************/
/**
 * Object Document()
 * https://www.w3.org/TR/domcore/#document
 * 
 * @arguments Object
 * @constructor
 * @since Level 4 Document Object Model Core Definition.
 * @see Node  
 */ 
function Document(){};
Document.prototype = new Node();
/**
 * Property compatMode 
 * https://www.w3.org/TR/domcore/#document 
 *
 * @type String
 * @since Level 4 Document Object Model Core Definition.    
 * @see Document
 */ 
Document.prototype.compatMode = ""; 
/**
 * Property characterSet
 * https://www.w3.org/TR/domcore/#document 
 *
 * @type String
 * @since Level 4 Document Object Model Core Definition.    
 * @see Document
 */ 
Document.prototype.characterSet = ""; 
/**
 * Property contentType
 * https://www.w3.org/TR/domcore/#document 
 *
 * @type String
 * @since Level 4 Document Object Model Core Definition.    
 * @see Document
 */ 
Document.prototype.contentType = ""; 
/**
 * Property doctype 
 * https://www.w3.org/TR/domcore/#document 
 *
 * @type String
 * @since Level 4 Document Object Model Core Definition.    
 * @see Document
 */ 
Document.prototype.doctype = new DocumentType();
/**
 * Property documentElement 
 * https://www.w3.org/TR/domcore/#document 
 *
 * @type Element
 * @since Level 4 Document Object Model Core Definition.    
 * @see Element
 */ 
Document.prototype.documentElement= new Element(); 
/**
 * function getElementsByTagName(localName)  
 * https://www.w3.org/TR/domcore/#document
 * 
 * @param {String} localName
 * @returns {HTMLCollection}
 * @since Level 4 Document Object Model Core Definition.
 * @see HTMLCollection     
 */
Document.prototype.getElementsByTagName=function(localName){return new HTMLCollection();}; 
/**
 * function getElementsByClassName(className)  
 * https://www.w3.org/TR/domcore/#document
 * 
 * @param {String} className
 * @returns {HTMLCollection}
 * @since Level 4 Document Object Model Core Definition.
 * @see HTMLCollection     
 */
Document.prototype.getElementsByclassName=function(className){return new HTMLCollection();}; 
/**
 * function createElement(localName)  
 * https://www.w3.org/TR/domcore/#document
 * 
 * @param {String} localName
 * @returns {Element}
 * @throws DOMException
 * @since Level 4 Document Object Model Core Definition.  
 * @see Element  
 */  
Document.prototype.createElement=function(localName){return new Element();}; 
/**
 * function createTextNode(data)  
 * https://www.w3.org/TR/domcore/#document
 * 
 * @param {String} data
 * @returns {Text}
 * @since Level 4 Document Object Model Core Definition.  
 * @see Text 
 */ 
Document.prototype.createTextNode=function(data){return new Text();}; 
/**
 * function createComment(data)  
 * https://www.w3.org/TR/domcore/#document
 * 
 * @param {String} data
 * @returns {Comment}
 * @since Level 2 Document Object Model Core Definition. 
 * @see Comment   
 */ 
Document.prototype.createComment=function(data){return new Comment();}; 

/************************************* Blob ********************************************/

/************************************* Page Visibility ********************************************/
/**
 * https://www.w3.org/TR/page-visibility/
 * @Extension Document Object
 */ 

/**
 * Property hidden 
 * @type Boolean
 */ 
Document.prototype.hidden = false; 
/**
 * Property visibilityState 
 * @type VisibilityState
 */ 
Document.prototype.visibilityState = new VisibilityState(); 
/**
 * Property visibilitychange  
 * @type EventHandler   
 */
Document.prototype.visibilitychange = new EventHandler(); 

/************************************* Geolocation ********************************************/
/**
 * Property geolocation
 * https://dev.w3.org/geo/api/spec-source.html#api_description
 * @type Geolocation
 * @memberOf Navigator
 */
Navigator.prototype.geolocation=new Geolocation();

/**
 * Object Geolocation()
 * https://dev.w3.org/geo/api/spec-source.html#api_description
 */
function Geolocation(){};
Geolocation.prototype=new Object();

/**
 * function getCurrentPosition(successCallback,errorCallback,options)
 * https://dev.w3.org/geo/api/spec-source.html#api_description
 * @param {Function} successCallback
 * @param {Function} errorCallback - optional
 * @param {PositionOptions} options - optional
 * @memberOf Geolocation
 */
Geolocation.prototype.getCurrentPosition=function(successCallback,errorCallback,options){};

/************************************* DocumentType ********************************************/
/**
 * Object DocumentType()
 * https://www.w3.org/TR/domcore/#interface-documenttype
 * 
 * @arguments Node
 * @constructor
 * @since Level 4 Document Object Model Core Definition.
 * @see Node
 */
function DocumentType(){};
DocumentType.prototype = new Node();
/**
 * Property name
 * https://www.w3.org/TR/domcore/#interface-documenttype
 * 
 * @type String 
 * @since Standard ECMA-262 3rd. Edition 
 * @since Level 4 Document Object Model Core Definition.    
 */
DocumentType.prototype.name=""; 

/************************************* Element ********************************************/
/**
 * Object Element()
 * https://www.w3.org/TR/domcore/#element
 * 
 * @arguments Node
 * @constructor
 * @since Level 4 Document Object Model Core Definition.
 * @see Node
 */
function Element(){};
Element.prototype=new Node(); 
/**
 * Property localName
 * @type   String
 * @since Level 4 Document Object Model Core Definition.     
 */
Element.prototype.localName="";
/**
 * Property tagName  
 * @type   String
 * @since Level 4 Document Object Model Core Definition.     
 */
Element.prototype.tagName="";
/**
 * Property id
 * @type   String
 * @since Level 4 Document Object Model Core Definition.     
 */
Element.prototype.id="";
/**
 * Property className  
 * @type   String
 * @since Level 4 Document Object Model Core Definition.     
 */
Element.prototype.className="";
/**
 * Property className  
 * @type   String
 * @since Level 4 Document Object Model Core Definition.     
 */
Element.prototype.classList= new DOMTokenList();
/**
 * function getAttribute(name) 
 * https://www.w3.org/TR/domcore/#element
 *  
 * @param {String} name
 * @returns {String}
 * @since Level 4 Document Object Model Core Definition.    
 */
Element.prototype.getAttribute=function(name){return "";}; 
/**
 * function setAttribute(name, value) 
 * https://www.w3.org/TR/domcore/#element
 *  
 * @param {String} name
 * @param {String} value
 * @throws DOMException
 * @since Level 4 Document Object Model Core Definition.    
 */
Element.prototype.setAttribute=function(name, value){}; 
/**
 * function removeAttribute(name)
 * https://www.w3.org/TR/domcore/#element
 *  
 * @param {String} name
 * @throws DOMException
 * @since Level 4 Document Object Model Core Definition.    
 */
Element.prototype.removeAttribute=function(name){}; 
/**
 * function hasAttribute(name)   
 * https://www.w3.org/TR/domcore/#element
 *  
 * @param {String} name
 * @returns {Boolean}
 * @since Level 4 Document Object Model Core Definition.    
 */ 
Element.prototype.hasAttribute=function(name){return false;}; 
/**
 * function getElementsByTagName(localName)
 * https://www.w3.org/TR/domcore/#element
 *  
 * @param {String} localName
 * @returns {HTMLCollection}
 * @since Level 4 Document Object Model Core Definition.    
 */
Element.prototype.getElementsByTagName=function(name){return new HTMLCollection;}; 
/**
 * function getElementsByClassName(className)
 * https://www.w3.org/TR/domcore/#element
 *  
 * @param {String} className
 * @returns {HTMLCollection}
 * @since Level 4 Document Object Model Core Definition.    
 */
Element.prototype.getElementsByClassName=function(name){return new HTMLCollection;};

/************************************* Attr ********************************************/
/**
 * Object Attr()
 * https://www.w3.org/TR/domcore/#attr
 * 
 * @arguments Object
 * @constructor
 * @since Level 4 Document Object Model Core Definition.
 * @see Object
 */
function Attr(){};
Attr.prototype=new Object(); 
/**
 * Property name
 * @type   String
 * @since Level 4 Document Object Model Core Definition.     
 */
Attr.prototype.name="";
/**
 * Property value
 * @type   String
 * @since Level 4 Document Object Model Core Definition.     
 */
Attr.prototype.value="";
/**
 * Property specified
 * @type   Boolean
 * @since Level 4 Document Object Model Core Definition.     
 */
Attr.prototype.specified=true;

/************************************* CharacterData ********************************************/
/**
 * Object CharacterData()
 * https://www.w3.org/TR/domcore/#characterdata
 * 
 * @arguments Node
 * @constructor
 * @since Level 4 Document Object Model Core Definition.
 * @see Node
 */
function CharacterData(){};
CharacterData.prototype=new Node(); 
/**
 * Property data
 * @type   String
 * @since Level 4 Document Object Model Core Definition.     
 */
CharacterData.prototype.data="";
/**
 * Property length
 * @type   Number
 * @since Level 4 Document Object Model Core Definition.     
 */
CharacterData.prototype.length=0;

/************************************* Text ********************************************/
/**
 * Object Text()
 * https://www.w3.org/TR/domcore/#text
 * 
 * @arguments CharacterData
 * @constructor
 * @since Level 4 Document Object Model Core Definition.
 * @see CharacterData
 */
function Text(){};
Text.prototype=new CharacterData();
/**
 * Property wholeText
 * @type   String
 * @since Level 4 Document Object Model Core Definition.     
 */
Text.prototype.wholeText="";

/************************************* Comment ********************************************/
/**
 * Object Comment()
 * https://www.w3.org/TR/domcore/#interface-comment
 * 
 * @arguments CharacterData
 * @constructor
 * @since Level 4 Document Object Model Core Definition.
 * @see CharacterData
 */
function Comment(){};
Comment.prototype = new CharacterData();

/************************************* DOMTokenList ********************************************/
/**
 * Object DOMTokenList()
 * https://www.w3.org/TR/domcore/#interface-domtokenlist
 * 
 * @arguments Object
 * @constructor
 * @since Level 4 Document Object Model Core Definition.
 * @see Object
 */
function DOMTokenList(){};
DOMTokenList.prototype=new Object();
/**
 * Property length
 * @type   Number
 * @since Level 4 Document Object Model Core Definition.     
 */
DOMTokenList.prototype.length=0;
/**
 * function item(index)   
 * https://www.w3.org/TR/domcore/#interface-domtokenlist
 *  
 * @param {Number} index
 * @returns {String}
 * @since Level 4 Document Object Model Core Definition.    
 */ 
DOMTokenList.prototype.item=function(index){return "";}; 
/**
 * function contains(token)   
 * https://www.w3.org/TR/domcore/#interface-domtokenlist
 *  
 * @param {String} token
 * @returns {Boolean}
 * @since Level 4 Document Object Model Core Definition.    
 */ 
DOMTokenList.prototype.contains=function(token){return false;}; 
/**
 * function add(tokens)   
 * https://www.w3.org/TR/domcore/#interface-domtokenlist
 *  
 * @param {String} tokens
 * @since Level 4 Document Object Model Core Definition.    
 */ 
DOMTokenList.prototype.add=function(tokens){}; 
/**
 * function remove(tokens)   
 * https://www.w3.org/TR/domcore/#interface-domtokenlist
 *  
 * @param {String} tokens
 * @since Level 4 Document Object Model Core Definition.    
 */ 
DOMTokenList.prototype.remove=function(tokens){};
/**
 * function toggle(token, force)
 * https://www.w3.org/TR/domcore/#interface-domtokenlist
 *  
 * @param {String} token
 * @param {Boolean} force
 * @returns {Boolean}
 * @since Level 4 Document Object Model Core Definition.    
 */ 
DOMTokenList.prototype.toggle=function(token, force){return false;};

/************************************* Navigator ********************************************/
/**
 * Object Navigator()
 * @super Object
 * @constructor
 * @since Common Usage, no standard
*/
function Navigator(){};
Navigator.prototype = new Object();
Navigator.prototype.navigator = new Navigator();
/**
 * Property appCodeName
 * @type String
 * @memberOf Navigator
 */
Navigator.prototype.appCodeName = "";
/**
 * Property appName
 * @type String
 * @memberOf Navigator
 */
Navigator.prototype.appName = "";
/**
 * Property appVersion
 * @type String
 * @memberOf Navigator
 */
Navigator.prototype.appVersion = "";
/**
 * Property cookieEnabled
 * @type Boolean
 * @memberOf Navigator
 */
Navigator.prototype.cookieEnabled = new Boolean();
/**
 * Property mimeTypes
 * @type Array
 * @memberOf Navigator
 */
Navigator.prototype.mimeTypes = new Array();
/**
 * Property platform
 * @type String
 * @memberOf Navigator
 */
Navigator.prototype.platform = "";
/**
 * Property plugins
 * @type Array
 * @memberOf Navigator
 */
Navigator.prototype.plugins = new Array();
/**
 * Property userAgent
 * @type String
 * @memberOf Navigator
 */
Navigator.prototype.userAgent = "";
/**
 * function javaEnabled()
 * @returns {Boolean}
 * @memberOf Navigator
 */
Navigator.prototype.javaEnabled = function(){return false;};

/************************************* Window ********************************************/
/**
 * Object Window()
 * https://www.w3.org/TR/html5/browsers.html#the-window-object
 * 
 * @arguments EventTarget
 * @super Global
 * @constructor
 * @see EventTarget
 */
function Window(){};
Window.prototype = new EventTarget();
Window.prototype.window = new Window();
/**
 * Property navigator
 * @type Navigator
 * @memberOf Window
 */
Window.prototype.navigator = new Navigator();
/**
 * Property document
 * @type Document
 * @memberOf Window
 */
Window.prototype.document= new HTMLDocument();
 /**
 * Property innerWidth
 * @type Number
 * @memberOf Window
 */
Window.prototype.innerWidth = 0;
/**
 * Property innerHeight
 * @type Number
 * @memberOf Window
 */
Window.prototype.innerHeight = 0;


/********************* Timing Control for Script-based Animations **************************/
/**
 * Extension Window Object
 * https://www.w3.org/TR/animation-timing/
 */

/**
 * function requestAnimationFrame(callback)
 *  
 * @param {FrameRequestCallback} callback
 * @returns {Number}
 */
Window.prototype.requestAnimationFrame = function(callback){return 0;};
/**
 * function cancelAnimationFrame(handle)
 *  
 * @param {Number} handle
 */
Window.prototype.cancelAnimationFrame = function(handle){};


/************************************* WindowTimers ********************************************/
/**
 * Object WindowTimers()
 * https://www.w3.org/TR/html5/webappapis.html#timers
 * 
 * @arguments Object
 * @constructor
 * @see Object
 */
function WindowTimers(){};
WindowTimers.prototype = new Object();
/**
 * function setInterval(handle, timeout) 
 * @param {Function} handle
 * @param {Number} timeout
 * @memberOf Window
 * @returns {Number}
 */
WindowTimers.prototype.setInterval=function(handle, timeout){return 0;};
/**
 * function setTimeout(handle, timeout) 
 * @param {Function} handle
 * @param {Number} timeout
 * @memberOf Windowtimeout
 * @returns {Number}
 */
WindowTimers.prototype.setTimeout=function(handle, timeout){ return 0;};
/**
 * function clearInterval(handle) 
 * @param handle
 * @memberOf Window
 */
WindowTimers.prototype.clearInterval = function(handle){};
/**
 * function clearTimeout(handle) 
 * @param handle
 * @memberOf Window
 */
WindowTimers.prototype.clearTimeout = function(handle){};

/********************************* GlobalEventHandlers  ****************************************/
/**
 * Object GlobalEventHandlers()
 * https://www.w3.org/TR/html5/webappapis.html#event-handler-attributes
 * 
 * @arguments Object
 * @constructor
 * @see Object
 */
function GlobalEventHandlers(){};
GlobalEventHandlers.prototype = new Object();
/**
 * Property onclick
 * @type Event
 * @memberOf GlobalEventHandlers
 */
GlobalEventHandlers.prototype.onclick = new EventHandler();
/**
 * Property onload
 * @type Event
 * @memberOf GlobalEventHandlers
 */
GlobalEventHandlers.prototype.onload = new EventHandler();

/********************************* Blob ****************************************/
/**
 * Object Blob()
 * https://w3c.github.io/FileAPI/#blob
 * @arguments Object
 * @constructor
 * @see Object
 */
function Blob(){};
Blob.prototype = new Object();
Blob.prototype.size = 0;
Blob.prototype.type = "";
Blob.prototype.isClosed = false;
Blob.prototype.slice = function(start, end, contentType){return new Blob();};
Blob.prototype.close = function(){};

/********************************* Event ****************************************/
/**
 * Object Event()
 * https://www.w3.org/TR/domcore/#interface-event
 * 
 * @arguments Object
 * @constructor
 * @see Object
 */
function Event(){};
Event.prototype = new Object();
Event.prototype.NONE = 0;
Event.prototype.CAPTURING_PHASE = 1;
Event.prototype.AT_TARGET = 2;
Event.prototype.BUBBLING_PHASE = 3;

Event.prototype.bubbles = false;
Event.prototype.cancelable = false;
Event.prototype.currentTarget = new EventTarget();
Event.prototype.eventPhase = 0;
Event.prototype.target = new EventTarget();
Event.prototype.timeStamp = 0;
Event.prototype.type = "";
Event.prototype.defaultPrevented = false;

Event.prototype.stopPropagation=function(){};
Event.prototype.stopImmediatePropagation=function(){};
Event.prototype.preventDefault=function(){};

Event.EventInit.bubbles = false;
Event.EventInit.cancelable = false;

/********************************* EventTarget ****************************************/
/**
 * Object EventTarget()
 * https://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-EventTarget
 * 
 * @arguments Object
 * @constructor
 * @see Object
 */
function EventTarget(){};
EventTarget.prototype=new Object();
/**
 * @memberOf Window
 * @param {String} type
 * @param {EventListener} listener
 * @param {Boolean} useCapture
 */
EventTarget.prototype.addEventListener=function(type, listener, useCapture){};
/**
 * @memberOf Window
 * @param {String} type
 * @param {EventListener} listener
 * @param {Boolean} useCapture
 */
EventTarget.prototype.removeEventListener=function(type, listener, useCapture){};

/********************************* EventListner ****************************************/
function EventListener(){};
EventListener.prototype=new Object();
/**
 * @param {Event} event
 * @memberOf EventListener
 */
EventListener.prototype.handleEvent=function(event){};

/********************************* ProgressEvent ****************************************/
function ProgressEvent(){};
ProgressEvent.prototype=new Event();

ProgressEvent.prototype.lengthComputable = false;
ProgressEvent.prototype.loaded = 0;
ProgressEvent.prototype.total = 0;
ProgressEvent.ProgressEvenInit.lengthComputable = false;
ProgressEvent.ProgressEvenInit.loaded = 0;
ProgressEvent.ProgressEvenInit.total = 0;

/********************************* XMLHttpRequest ****************************************/
/**
* function createRequest
* @type XMLHttpRequest
* @memberOf Window
*/
Window.prototype.createRequest= function(){return new XMLHttpRequest();};

/**
 * Object XMLHttpRequestEventTarget ()
 * https://www.w3.org/TR/XMLHttpRequest/#interface-xmlhttprequest
 * @type constructor
 */
function XMLHttpRequestEventTarget(){};
XMLHttpRequestEventTarget.prototype = new EventTarget();
/**
 * Property onloadstart
 * @type EventHandler
 */
XMLHttpRequestEventTarget.prototype.onloadstart = new EventHandler;
/**
 * Property onprogress
 * @type EventHandler
 */
XMLHttpRequestEventTarget.prototype.onprogress = new EventHandler;
/**
 * Property onabort
 * @type EventHandler
 */
XMLHttpRequestEventTarget.prototype.onabort = new EventHandler;
/**
 * Property onerror
 * @type EventHandler
 */
XMLHttpRequestEventTarget.prototype.onerror = new EventHandler;
/**
 * Property onload
 * @type EventHandler
 */
XMLHttpRequestEventTarget.prototype.onload = new EventHandler;
/**
 * Property ontimeout
 * @type EventHandler
 */
XMLHttpRequestEventTarget.prototype.ontimeout = new EventHandler;
/**
 * Property onloadend
 * @type EventHandler
 */
XMLHttpRequestEventTarget.prototype.onloadend = new EventHandler;

/**
 * Object XMLHttpRequestEventTarget ()
 * https://www.w3.org/TR/XMLHttpRequest/#interface-xmlhttprequest
 * @type constructor
 */
function XMLHttpRequestUpload (){};
XMLHttpRequestUpload.prototype = new XMLHttpRequestEventTarget ();

/**
 * Object XMLHttpRequest()
 * https://www.w3.org/TR/XMLHttpRequest/#interface-xmlhttprequest
 * @type constructor
 */
function XMLHttpRequest(){};
XMLHttpRequest.prototype = new XMLHttpRequestEventTarget();
/**
 * Constant UNSENT = 0;
 * @constant
 * @type Number
 */
XMLHttpRequest.UNSENT = 0;
/**
 * Constant OPENED = 1;
 * @constant
 * @type Number
 */
XMLHttpRequest.OPENED = 1;
/**
 * Constant HEADERS_RECEIVED = 2;
 * @constant
 * @type Number
 */
XMLHttpRequest.HEADERS_RECEIVED = 2;
/**
 * Constant LOADING = 3;
 * @constant
 * @type Number
 */
XMLHttpRequest.LOADING = 3;
/**
 * Constant DONE = 4;
 * @constant
 * @type Number
 */
XMLHttpRequest.DONE = 4;
/**
 * Property onreadystatechange
 * @type EventHandler
 */
XMLHttpRequest.prototype.onreadystatechange = new EventHandler;
/**
 * Property readyState
 * @type Number
 */
XMLHttpRequest.prototype.readyState = 0;
/**
 * Property timeout
 * @type Number
 */
XMLHttpRequest.prototype.timeout = 0;
/**
 * Property status
 * @type Number
 */
XMLHttpRequest.prototype.status = 0;
/**
 * Property responseType
 * @type XMLHttpRequestResponseType
 */
XMLHttpRequest.prototype.responseType = new XMLHttpRequestResponseType();
/**
 * Property response
 * @type String
 */
XMLHttpRequest.prototype.response = "";
/**
 * Property responseText
 * @type String
 */
XMLHttpRequest.prototype.responseText = "";
/**
 * Property statusText
 * @type ByteString
 */
XMLHttpRequest.prototype.statusText = "";
/**
* function open(method, url, async, username, password)
* @param {String} method
* @param {String} url
* @param {Boolean} optional async
* @param {String} optional username
* @param {String} optional password
* @memberOf XMLHttpRequest
*/
XMLHttpRequest.prototype.open=function(method, url, async, username, password){};
/**
* function setRequestHeader(header,value)
* @param {String} header
* @param {String} value
* @memberOf XMLHttpRequest
*/
XMLHttpRequest.prototype.setRequestHeader=function(header,value){};
/**
* function send(body)
* @param {Object} body
* @memberOf XMLHttpRequest
*/
XMLHttpRequest.prototype.send=function(body){};
/**
 * function abort()
 * @memberOf XMLHttpRequest
 */
XMLHttpRequest.prototype.abort=function(){};
/**
* function getResponseHeader(header)
* @param {String} header
* @type String
* @memberOf XMLHttpRequest
*/
XMLHttpRequest.prototype.getResponseHeader=function(header){return "";};
/**
* function getAllResponseHeaders()
* @type String
* @memberOf XMLHttpRequest
*/
XMLHttpRequest.prototype.getAllResponseHeaders=function(){return "";};



