/********************************* Tizen Web Device API ****************************************/
/**
 * The root of the Tizen Web Device API.
 * This is the Tizen root interface.
 * It is a property of the ECMAScript global object, as specified by the <em>TizenObject</em> interface.
 *
 * @super Object
 * @constructor
 * @return {Tizen}
 */
function Tizen() {};
Tizen.prototype = new Object();


/********************************* FileSystemManagerObject ****************************************/
/**
 * Object EventTarget()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/filesystem.html
 * 
 * @augments Object
 * @constructor
 * @see Object
 */
function FileSystemManagerObject() {};
FileSystemManagerObject.prototype = new Object();
/**
 * Property filesystem
 * @type FileSystemManager
 */
FileSystemManagerObject.prototype.filesystem = new FileSystemManager();

/********************************* FileSystemManager ****************************************/
/**
 * Object FileSystemManager()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/filesystem.html
 * 
 * @augments Object
 * @constructor
 * @see Object
 */
function FileSystemManager() {};
FileSystemManager.prototype = new Object();
/**
 * Property maxPathLength
 * @type Number
 */
FileSystemManager.prototype.maxPathLength = new Number();
/**
 * function resolve(location, onsuccess, onerror, mode) 
 *
 * @param {String} location
 * @param {FileSuccessCallback} onsuccess
 * @param {ErrorCallback} onerror
 * @param {FileMode} mode
 * @type void
 * @memberOf FileSystemManager
 * @returns {void}
 */ 
FileSystemManager.prototype.resolve = function(location, onsuccess, onerror, mode){ return; };
/**
 * function getStorage(label, onsuccess, onerror) 
 *
 * @param {String} label
 * @param {FileSystemStorageSuccessCallback} onsuccess
 * @param {ErrorCallback} onerror
 * @type void
 * @memberOf FileSystemManager
 * @returns {void}
 */ 
FileSystemManager.prototype.getStorage = function(label, onsuccess, onerror){ return; };
/**
 * function listStorages(onsuccess, onerror) 
 *
 * @param {FileSystemStorageArraySuccessCallback} onsuccess
 * @param {ErrorCallback} onerror
 * @type void
 * @memberOf FileSystemManager
 * @returns {void}
 */
FileSystemManager.prototype.listStorages = function(onsuccess, onerror){ return; };
/**
 * function addStorageStateChangeListener(onsuccess, onerror)
 *
 * @param {FileSystemStorageSuccessCallback} onsuccess
 * @param {ErrorCallback} onerror
 * @type Number
 * @memberOf FileSystemManager
 * @returns {Number}
 */
FileSystemManager.prototype.addStorageStateChangeListener = function(onsuccess, onerror){ var ret = new Number(); return ret; };
/**
 * function removeStorageStateChangeListener(watchId)
 *
 * @param {Number} watchId
 * @type void
 * @memberOf FileSystemManager
 * @returns {void}
 */
FileSystemManager.prototype.removeStorageStateChangeListener = function(watchId){ return; };
/**
 * Property filesystem
 * @type FileSystemManager
 */
Tizen.prototype.filesystem = new FileSystemManager();

/********************************* FileSystemStorage ****************************************/
/**
 * Object FileSystemManager()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/filesystem.html
 *
 * @super Object
 * @constructor
 * @return {FileSystemStorage}
 */
function FileSystemStorage() {};
FileSystemStorage.prototype = new Object();
/**
 * Property label
 * @type String
 */
FileSystemStorage.prototype.label = new String();
/**
 * Property type
 * @type FileSystemStorageType
 */
FileSystemStorage.prototype.type = new FileSystemStorageType();
/**
 * Property state
 * @type FileSystemStorageState
 */
FileSystemStorage.prototype.state = new FileSystemStorageState();

/********************************* File ****************************************/
/**
 * Object File()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/filesystem.html
 *
 * @super Object
 * @constructor
 * @return {File}
 */
function File() {};
File.prototype = new Object();
/**
 * Property parent
 * @type File
 */
File.prototype.parent = new File();
/**
 * Property readOnly
 * @type Boolean
 */
File.prototype.readOnly = new Boolean();
/**
 * Property isFile
 * @type Boolean
 */
File.prototype.isFile = new Boolean();
/**
 * Property isDirectory
 * @type Boolean
 */
File.prototype.isDirectory = new Boolean();
/**
 * Property created
 * @type Date
 */
File.prototype.created = new Date();
/**
 * Property modified
 * @type Date
 */
File.prototype.modified = new Date();
/**
 * Property path
 * @type String
 */
File.prototype.path = new String();
/**
 * Property name
 * @type String
 */
File.prototype.name = new String();
/**
 * Property fullPath
 * @type String
 */
File.prototype.fullPath = new String();
/**
 * Property fileSize
 * @type Number
 */
File.prototype.fileSize = new Number();
/**
 * Property length
 * @type Number
 */
File.prototype.length = new Number();
/**
 * function toURI()
 *
 * @type String
 * @memberOf File
 * @returns {String}
 */
File.prototype.toURI = function(){ var ret = new String(); return ret; };
/**
 * function listFiles(onsuccess, onerror, filter)
 *
 * @param {FileArraySuccessCallback} onsuccess
 * @param {ErrorCallback} onerror
 * @param {FileFilter} filter
 * @type void
 * @memberOf File
 * @returns {void}
 */
File.prototype.listFiles = function(onsuccess, onerror, filter){ return; };
/**
 * function openStream(mode, onsuccess, onerror, encoding)
 *
 * @param {FileMode} mode
 * @param {FileStreamSuccessCallback} onsuccess
 * @param {ErrorCallback} onerror
 * @param {String} encoding
 * @type void
 * @memberOf File
 * @returns {void}
 */
File.prototype.openStream = function(mode, onsuccess, onerror, encoding){ return; };
/**
 * function readAsText(onsuccess, onerror, encoding)
 *
 * @param {FileStringSuccessCallback} onsuccess
 * @param {ErrorCallback} onerror
 * @param {String} encoding
 * @type void
 * @memberOf File
 * @returns {void}
 */
File.prototype.readAsText = function(onsuccess, onerror, encoding){ return; };
/**
 * function copyTo(originFilePath, destinationFilePath, overwrite, onsuccess, onerror)
 *
 * @param {String} originFilePath
 * @param {String} destinationFilePath
 * @param {Boolean} overwrite
 * @param {SuccessCallback} onsuccess
 * @param {ErrorCallback} onerror
 * @type void
 * @memberOf File
 * @returns {void}
 */
File.prototype.copyTo = function(originFilePath, destinationFilePath, overwrite, onsuccess, onerror){ return; };
/**
 * function moveTo(originFilePath, destinationFilePath, overwrite, onsuccess, onerror)
 *
 * @param {String} originFilePath
 * @param {String} destinationFilePath
 * @param {Boolean} overwrite
 * @param {SuccessCallback} onsuccess
 * @param {ErrorCallback} onerror
 * @type void
 * @memberOf File
 * @returns {void}
 */
File.prototype.moveTo = function(originFilePath, destinationFilePath, overwrite, onsuccess, onerror){ return; };
/**
 * function createDirectory(dirPath)
 *
 * @param {String} dirPath
 * @type File
 * @memberOf File
 * @returns {File}
 */
File.prototype.createDirectory = function(dirPath){ var ret = new File(); return ret; };
/**
 * function createFile(relativeFilePath)
 *
 * @param {String} relativeFilePath
 * @type File
 * @memberOf File
 * @returns {File}
 */
File.prototype.createFile = function(relativeFilePath){ var ret = new File(); return ret; };
/**
 * function resolve(filePath)
 *
 * @param {String} filePath
 * @type File
 * @memberOf File
 * @returns {File}
 */
File.prototype.resolve = function(filePath){ var ret = new File(); return ret; };
/**
 * function deleteDirectory(directoryPath, recursive, onsuccess, onerror)
 *
 * @param {String} directoryPath
 * @param {Boolean} recursive
 * @param {SuccessCallback} onsuccess
 * @param {ErrorCallback} onerror
 * @type void
 * @memberOf File
 * @returns {void}
 */
File.prototype.deleteDirectory = function(directoryPath, recursive, onsuccess, onerror){ return; };
/**
 * function deleteFile(filePath, onsuccess, onerror)
 *
 * @param {String} filePath
 * @param {SuccessCallback} onsuccess
 * @param {ErrorCallback} onerror
 * @type void
 * @memberOf File
 * @returns {void}
 */
File.prototype.deleteFile = function(filePath, onsuccess, onerror){ return; };

/********************************* FileFilter ****************************************/
/**
 * Object FileFilter()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/filesystem.html
 */

/********************************* FileStream ****************************************/
/**
 * Object FileStream()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/filesystem.html
 *
 * @super Object
 * @constructor
 * @return {FileStream}
 */
function FileStream() {};
FileStream.prototype = new Object();
/**
 * Property eof
 * @type Boolean
 */
FileStream.prototype.eof = new Boolean();
/**
 * Property bytesAvailable
 * @type Number
 */
FileStream.prototype.bytesAvailable = new Number();
/**
 * function close()
 *
 * @type void
 * @memberOf FileStream
 * @returns {void}
 */
FileStream.prototype.close = function(){ return; };
/**
 * function read(charCount)
 *
 * @param {Number} charCount
 * @type String
 * @memberOf FileStream
 * @returns {String}
 */
FileStream.prototype.read = function(charCount){ var ret = new String(); return ret; };
/**
 * function readBytes(byteCount)
 *
 * @param {Number} byteCount
 * @type array
 * @memberOf FileStream
 * @returns {array}
 */
FileStream.prototype.readBytes = function(byteCount){ var ret = new array(); return ret; };
/**
 * function readBase64(byteCount)
 *
 * @param {Number} byteCount
 * @type String
 * @memberOf FileStream
 * @returns {String}
 */
FileStream.prototype.readBase64 = function(byteCount){ var ret = new String(); return ret; };
/**
 * function write(stringData)
 *
 * @param {String} stringData
 * @type void
 * @memberOf FileStream
 * @returns {void}
 */
FileStream.prototype.write = function(stringData){ return; };
/**
 * function writeBytes(byteData)
 *
 * @param {array} byteData
 * @type void
 * @memberOf FileStream
 * @returns {void}
 */
FileStream.prototype.writeBytes = function(byteData){ return; };
/**
 * function writeBase64(base64Data)
 *
 * @param {String} base64Data
 * @type void
 * @memberOf FileStream
 * @returns {void}
 */
FileStream.prototype.writeBase64 = function(base64Data){ return; };

/********************************* FileSuccessCallback ****************************************/
/**
 * Object FileSuccessCallback()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/filesystem.html
 *
 * @super Object
 * @constructor
 * @return {FileSuccessCallback}
 */
function FileSuccessCallback() {};
FileSuccessCallback.prototype = new Object();
/**
 * function onsuccess(file)
 *
 * @param {File} file
 * @type void
 * @memberOf FileSuccessCallback
 * @returns {void}
 */
FileSuccessCallback.prototype.onsuccess = function(file){ return; };

/*************************** FileSystemStorageArraySuccessCallback **********************************/
/**
 * Object FileSystemStorageArraySuccessCallback()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/filesystem.html
  *
 * @super Object
 * @constructor
 * @return {FileSystemStorageArraySuccessCallback}
 */
function FileSystemStorageArraySuccessCallback() {};
FileSystemStorageArraySuccessCallback.prototype = new Object();
/**
 * function onsuccess(storages)
 *
 * @param {array} storages
 * @type void
 * @memberOf FileSystemStorageArraySuccessCallback
 * @returns {void}
 */
FileSystemStorageArraySuccessCallback.prototype.onsuccess = function(storages){ return; };

/*************************** FileStringSuccessCallback **********************************/
/**
 * Object FileStringSuccessCallback()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/filesystem.html
 *
 * @super Object
 * @constructor
 * @return {FileStringSuccessCallback}
 */
function FileStringSuccessCallback() {};
FileStringSuccessCallback.prototype = new Object();
/**
 * function onsuccess(fileStr)
 *
 * @param {String} fileStr
 * @type void
 * @memberOf FileStringSuccessCallback
 * @returns {void}
 */
FileStringSuccessCallback.prototype.onsuccess = function(fileStr){ return; };

/*************************** FileStreamSuccessCallback **********************************/
/**
 * Object FileStreamSuccessCallback()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/filesystem.htmlc
 *
 * @super Object
 * @constructor
 * @return {FileStreamSuccessCallback}
 */
function FileStreamSuccessCallback() {};
FileStreamSuccessCallback.prototype = new Object();
/**
 * function onsuccess(filestream)
 *
 * @param {FileStream} filestream
 * @type void
 * @memberOf FileStreamSuccessCallback
 * @returns {void}
 */
FileStreamSuccessCallback.prototype.onsuccess = function(filestream){ return; };

/*************************** FileArraySuccessCallback **********************************/
/**
 * Object FileArraySuccessCallback()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/filesystem.html
 *
 * @super Object
 * @constructor
 * @return {FileArraySuccessCallback}
 */
function FileArraySuccessCallback() {};
FileArraySuccessCallback.prototype = new Object();
/**
 * function onsuccess(files)
 *
 * @param {array} files
 * @type void
 * @memberOf FileArraySuccessCallback
 * @returns {void}
 */
FileArraySuccessCallback.prototype.onsuccess = function(files){ return; };


/*************************** ApplicationManagerObject **********************************/
/**
 * Object ApplicationManagerObject()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/application.html
 *
 * @super Object
 * @constructor
 * @return {ApplicationManagerObject}
 */
function ApplicationManagerObject() {};
ApplicationManagerObject.prototype = new Object();
/**
 * Property application
 * @type ApplicationManager
 */
ApplicationManagerObject.prototype.application = new ApplicationManager();

/*************************** ApplicationManager **********************************/
/**
 * Object ApplicationManager()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/application.html
 *
 * @super Object
 * @constructor
 * @return {ApplicationManager}
 */
function ApplicationManager() {};
ApplicationManager.prototype = new Object();
/**
 * function getCurrentApplication()
 *
 * @type Application
 * @memberOf ApplicationManager
 * @returns {Application}
 */
ApplicationManager.prototype.getCurrentApplication = function(){ var ret = new Application(); return ret; };
/**
 * function kill(contextId, successCallback, errorCallback)
 *
 * @param {ApplicationContextId} contextId
 * @param {SuccessCallback} successCallback
 * @param {ErrorCallback} errorCallback
 * @type void
 * @memberOf ApplicationManager
 * @returns {void}
 */
ApplicationManager.prototype.kill = function(contextId, successCallback, errorCallback){ return; };
/**
 * function launch(id, successCallback, errorCallback)
 *
 * @param {ApplicationId} id
 * @param {SuccessCallback} successCallback
 * @param {ErrorCallback} errorCallback
 * @type void
 * @memberOf ApplicationManager
 * @returns {void}
 */
ApplicationManager.prototype.launch = function(id, successCallback, errorCallback){ return; };
/**
 * function launchAppControl(appControl, id, successCallback, errorCallback, replyCallback)
 *
 * @param {ApplicationControl} appControl
 * @param {ApplicationId} id
 * @param {SuccessCallback} successCallback
 * @param {ErrorCallback} errorCallback
 * @param {ApplicationControlDataArrayReplyCallback} replyCallback
 * @type void
 * @memberOf ApplicationManager
 * @returns {void}
 */
ApplicationManager.prototype.launchAppControl = function(appControl, id, successCallback, errorCallback, replyCallback){ return; };
/**
 * function findAppControl(appControl, successCallback, errorCallback)
 *
 * @param {ApplicationControl} appControl
 * @param {FindAppControlSuccessCallback} successCallback
 * @param {ErrorCallback} errorCallback
 * @type void
 * @memberOf ApplicationManager
 * @returns {void}
 */
ApplicationManager.prototype.findAppControl = function(appControl, successCallback, errorCallback){ return; };
/**
 * function getAppsContext(successCallback, errorCallback)
 *
 * @param {ApplicationContextArraySuccessCallback} successCallback
 * @param {ErrorCallback} errorCallback
 * @type void
 * @memberOf ApplicationManager
 * @returns {void}
 */
ApplicationManager.prototype.getAppsContext = function(successCallback, errorCallback){ return; };
/**
 * function getAppContext(contextId)
 *
 * @param {ApplicationContextId} contextId
 * @type ApplicationContext
 * @memberOf ApplicationManager
 * @returns {ApplicationContext}
 */
ApplicationManager.prototype.getAppContext = function(contextId){ var ret = new ApplicationContext(); return ret; };
/**
 * function getAppsInfo(successCallback, errorCallback)
 *
 * @param {ApplicationInformationArraySuccessCallback} successCallback
 * @param {ErrorCallback} errorCallback
 * @type void
 * @memberOf ApplicationManager
 * @returns {void}
 */
ApplicationManager.prototype.getAppsInfo = function(successCallback, errorCallback){ return; };
/**
 * function getAppInfo(id)
 *
 * @param {ApplicationId} id
 * @type ApplicationInformation
 * @memberOf ApplicationManager
 * @returns {ApplicationInformation}
 */
ApplicationManager.prototype.getAppInfo = function(id){ var ret = new ApplicationInformation(); return ret; };
/**
 * function getAppCerts(id)
 *
 * @param {ApplicationId} id
 * @type array
 * @memberOf ApplicationManager
 * @returns {array}
 */
ApplicationManager.prototype.getAppCerts = function(id){ var ret = new array(); return ret; };
/**
 * function getAppSharedURI(id)
 *
 * @param {ApplicationId} id
 * @type String
 * @memberOf ApplicationManager
 * @returns {String}
 */
ApplicationManager.prototype.getAppSharedURI = function(id){ var ret = new String(); return ret; };
/**
 * function getAppMetaData(id)
 *
 * @param {ApplicationId} id
 * @type array
 * @memberOf ApplicationManager
 * @returns {array}
 */
ApplicationManager.prototype.getAppMetaData = function(id){ var ret = new array(); return ret; };
/**
 * function addAppInfoEventListener(eventCallback)
 *
 * @param {ApplicationInformationEventCallback} eventCallback
 * @type Number
 * @memberOf ApplicationManager
 * @returns {Number}
 */
ApplicationManager.prototype.addAppInfoEventListener = function(eventCallback){ var ret = new Number(); return ret; };
/**
 * function removeAppInfoEventListener(watchId)
 *
 * @param {Number} watchId
 * @type void
 * @memberOf ApplicationManager
 * @returns {void}
 */
ApplicationManager.prototype.removeAppInfoEventListener = function(watchId){ return; };
/**
 * Property application
 * @type ApplicationManager
 */
Tizen.prototype.application = new ApplicationManager();

/*************************** Application **********************************/
/**
 * Object Application()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/application.html
 *
 * @super Object
 * @constructor
 * @return {Application}
 */
function Application() {};
Application.prototype = new Object();
/**
 * Property appInfo
 * @type ApplicationInformation
 */
Application.prototype.appInfo = new ApplicationInformation();
/**
 * Property contextId
 * @type ApplicationContextId
 */
Application.prototype.contextId = new ApplicationContextId();
/**
 * function exit()
 *
 * @type void
 * @memberOf Application
 * @returns {void}
 */
Application.prototype.exit = function(){ return; };
/**
 * function hide()
 *
 * @type void
 * @memberOf Application
 * @returns {void}
 */
Application.prototype.hide = function(){ return; };
/**
 * function getRequestedAppControl()
 *
 * @type RequestedApplicationControl
 * @memberOf Application
 * @returns {RequestedApplicationControl}
 */
Application.prototype.getRequestedAppControl = function(){ var ret = new RequestedApplicationControl(); return ret; };

/*************************** ApplicationInformation **********************************/
/**
 * Object ApplicationInformation()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/application.html
 *
 * @super Object
 * @constructor
 * @return {ApplicationInformation}
 */
function ApplicationInformation() {};
ApplicationInformation.prototype = new Object();
/**
 * Property id
 * @type ApplicationId
 */
ApplicationInformation.prototype.id = new ApplicationId();
/**
 * Property name
 * @type String
 */
ApplicationInformation.prototype.name = new String();
/**
 * Property iconPath
 * @type String
 */
ApplicationInformation.prototype.iconPath = new String();
/**
 * Property version
 * @type String
 */
ApplicationInformation.prototype.version = new String();
/**
 * Property show
 * @type Boolean
 */
ApplicationInformation.prototype.show = new Boolean();
/**
 * Property categories
 * @type array
 */
ApplicationInformation.prototype.categories = new array();
/**
 * Property installDate
 * @type Date
 */
ApplicationInformation.prototype.installDate = new Date();
/**
 * Property size
 * @type Number
 */
ApplicationInformation.prototype.size = new Number();
/**
 * Property packageId
 * @type PackageId
 */
ApplicationInformation.prototype.packageId = new PackageId();

/*************************** ApplicationContext **********************************/
/**
 * Object ApplicationContext()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/application.html
 *
 * @super Object
 * @constructor
 * @return {ApplicationContext}
 */
function ApplicationContext() {};
ApplicationContext.prototype = new Object();
/**
 * Property id
 * @type ApplicationContextId
 */
ApplicationContext.prototype.id = new ApplicationContextId();
/**
 * Property appId
 * @type ApplicationId
 */
ApplicationContext.prototype.appId = new ApplicationId();

/*************************** ApplicationControlData **********************************/
/**
 * Object ApplicationControlData()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/application.html
 *
 * @super Object
 * @constructor
 * @return {ApplicationControlData}
 */
function ApplicationControlData() {};
ApplicationControlData.prototype = new Object();
/**
 * Property key
 * @type String
 */
ApplicationControlData.prototype.key = new String();
/**
 * Property value
 * @type array
 */
ApplicationControlData.prototype.value = new array();

/*************************** ApplicationControl **********************************/
/**
 * Object ApplicationControl()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/application.html
 *
 * @super Object
 * @constructor
 * @return {ApplicationControl}
 */
function ApplicationControl() {};
ApplicationControl.prototype = new Object();
/**
 * Property operation
 * @type String
 */
ApplicationControl.prototype.operation = new String();
/**
 * Property uri
 * @type String
 */
ApplicationControl.prototype.uri = new String();
/**
 * Property mime
 * @type String
 */
ApplicationControl.prototype.mime = new String();
/**
 * Property category
 * @type String
 */
ApplicationControl.prototype.category = new String();
/**
 * Property data
 * @type array
 */
ApplicationControl.prototype.data = new array();

/*************************** RequestedApplicationControl **********************************/
/**
 * Object RequestedApplicationControl()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/application.html
 *
 * @super Object
 * @constructor
 * @return {RequestedApplicationControl}
 */
function RequestedApplicationControl() {};
RequestedApplicationControl.prototype = new Object();
/**
 * Property appControl
 * @type ApplicationControl
 */
RequestedApplicationControl.prototype.appControl = new ApplicationControl();
/**
 * Property callerAppId
 * @type ApplicationId
 */
RequestedApplicationControl.prototype.callerAppId = new ApplicationId();
/**
 * function replyResult(data)
 *
 * @param {array} data
 * @type void
 * @memberOf RequestedApplicationControl
 * @returns {void}
 */
RequestedApplicationControl.prototype.replyResult = function(data){ return; };
/**
 * function replyFailure()
 *
 * @type void
 * @memberOf RequestedApplicationControl
 * @returns {void}
 */
RequestedApplicationControl.prototype.replyFailure = function(){ return; };

/*************************** ApplicationCertificate **********************************/
/**
 * Object ApplicationCertificate()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/application.html
 *
 * @super Object
 * @constructor
 * @return {ApplicationCertificate}
 */
function ApplicationCertificate() {};
ApplicationCertificate.prototype = new Object();
/**
 * Property type
 * @type String
 */
ApplicationCertificate.prototype.type = new String();
/**
 * Property value
 * @type String
 */
ApplicationCertificate.prototype.value = new String();

/*************************** ApplicationMetaData **********************************/
/**
 * Object ApplicationMetaData()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/application.html
 *
 * @super Object
 * @constructor
 * @return {ApplicationMetaData}
 */
function ApplicationMetaData() {};
ApplicationMetaData.prototype = new Object();
/**
 * Property key
 * @type String
 */
ApplicationMetaData.prototype.key = new String();
/**
 * Property value
 * @type String
 */
ApplicationMetaData.prototype.value = new String();

/************************ ApplicationInformationArraySuccessCallback ***************************/
/**
 * Object ApplicationInformationArraySuccessCallback()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/application.html
 *
 * @super Object
 * @constructor
 * @return {ApplicationInformationArraySuccessCallback}
 */
function ApplicationInformationArraySuccessCallback() {};
ApplicationInformationArraySuccessCallback.prototype = new Object();
/**
 * function onsuccess(informationArray)
 *
 * @param {array} informationArray
 * @type void
 * @memberOf ApplicationInformationArraySuccessCallback
 * @returns {void}
 */
ApplicationInformationArraySuccessCallback.prototype.onsuccess = function(informationArray){ return; };

/************************ FindAppControlSuccessCallback ***************************/
/**
 * Object FindAppControlSuccessCallback()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/application.html
 *
 * @super Object
 * @constructor
 * @return {FindAppControlSuccessCallback}
 */
function FindAppControlSuccessCallback() {};
FindAppControlSuccessCallback.prototype = new Object();
/**
 * function onsuccess(informationArray, appControl)
 *
 * @param {array} informationArray
 * @param {ApplicationControl} appControl
 * @type void
 * @memberOf FindAppControlSuccessCallback
 * @returns {void}
 */
FindAppControlSuccessCallback.prototype.onsuccess = function(informationArray, appControl){ return; };

/************************ ApplicationContextArraySuccessCallback ***************************/
/**
 * Object ApplicationContextArraySuccessCallback()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/application.html
 *
 * @super Object
 * @constructor
 * @return {ApplicationContextArraySuccessCallback}
 */
function ApplicationContextArraySuccessCallback() {};
ApplicationContextArraySuccessCallback.prototype = new Object();
/**
 * function onsuccess(contexts)
 *
 * @param {array} contexts
 * @type void
 * @memberOf ApplicationContextArraySuccessCallback
 * @returns {void}
 */
ApplicationContextArraySuccessCallback.prototype.onsuccess = function(contexts){ return; };

/************************ ApplicationControlDataArrayReplyCallback ***************************/
/**
 * Object ApplicationControlDataArrayReplyCallback()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/application.html
 *
 * @super Object
 * @constructor
 * @return {ApplicationControlDataArrayReplyCallback}
 */
function ApplicationControlDataArrayReplyCallback() {};
ApplicationControlDataArrayReplyCallback.prototype = new Object();
/**
 * function onsuccess(data) 
 *
 * @param {array} data
 * @type void
 * @memberOf ApplicationControlDataArrayReplyCallback
 * @returns {void}
 */
ApplicationControlDataArrayReplyCallback.prototype.onsuccess = function(data){ return; };
/**
 * function onfailure() 
 *
 * @type void
 * @memberOf ApplicationControlDataArrayReplyCallback
 * @returns {void}
 */
ApplicationControlDataArrayReplyCallback.prototype.onfailure = function(){ return; };

/************************ ApplicationInformationEventCallback ***************************/
/**
 * Object ApplicationInformationEventCallback()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/application.html
 *
 * @super Object
 * @constructor
 * @return {ApplicationInformationEventCallback}
 */
function ApplicationInformationEventCallback() {};
ApplicationInformationEventCallback.prototype = new Object();
/**
 * function oninstalled(info) 
 *
 * @param {ApplicationInformation} info
 * @type void
 * @memberOf ApplicationInformationEventCallback
 * @returns {void}
 */
ApplicationInformationEventCallback.prototype.oninstalled = function(info){ return; };
/**
 * function onupdated(info) 
 *
 * @param {ApplicationInformation} info
 * @type void
 * @memberOf ApplicationInformationEventCallback
 * @returns {void}
 */
ApplicationInformationEventCallback.prototype.onupdated = function(info){ return; };
/**
 * function onuninstalled(id) 
 *
 * @param {ApplicationId} id
 * @type void
 * @memberOf ApplicationInformationEventCallback
 * @returns {void}
 */
ApplicationInformationEventCallback.prototype.onuninstalled = function(id){ return; };

/************************ MessagePortManagerObject ***************************/
/**
 * Object MessagePortManagerObject()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/messageport.html
 *
 * @super Object
 * @constructor
 * @return {MessagePortManagerObject}
 */
function MessagePortManagerObject() {};
MessagePortManagerObject.prototype = new Object();
/**
 * Property messageport
 * @type MessagePortManager
 */
MessagePortManagerObject.prototype.messageport = new MessagePortManager();

/************************ MessagePortManager ***************************/
/**
 * Object MessagePortManager()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/messageport.html
 *
 * @super Object
 * @constructor
 * @return {MessagePortManager}
 */
function MessagePortManager() {};
MessagePortManager.prototype = new Object();
/**
 * function requestLocalMessagePort(localMessagePortName) 
 *
 * @param {String} localMessagePortName
 * @type LocalMessagePort
 * @memberOf MessagePortManager
 * @returns {LocalMessagePort}
 */
MessagePortManager.prototype.requestLocalMessagePort = function(localMessagePortName){ var ret = new LocalMessagePort(); return ret; };
/**
 * function requestTrustedLocalMessagePort(localMessagePortName) 
 *
 * @param {String} localMessagePortName
 * @type LocalMessagePort
 * @memberOf MessagePortManager
 * @returns {LocalMessagePort}
 */
MessagePortManager.prototype.requestTrustedLocalMessagePort = function(localMessagePortName){ var ret = new LocalMessagePort(); return ret; };
/**
 * function requestRemoteMessagePort(appId, remoteMessagePortName)
 *
 * @param {ApplicationId} appId
 * @param {String} remoteMessagePortName
 * @type RemoteMessagePort
 * @memberOf MessagePortManager
 * @returns {RemoteMessagePort}
 */
MessagePortManager.prototype.requestRemoteMessagePort = function(appId, remoteMessagePortName){ var ret = new RemoteMessagePort(); return ret; };
/**
 * function requestTrustedRemoteMessagePort(appId, remoteMessagePortName)
 *
 * @param {ApplicationId} appId
 * @param {String} remoteMessagePortName
 * @type RemoteMessagePort
 * @memberOf MessagePortManager
 * @returns {RemoteMessagePort}
 */
MessagePortManager.prototype.requestTrustedRemoteMessagePort = function(appId, remoteMessagePortName){ var ret = new RemoteMessagePort(); return ret; };
/**
 * Property messageport
 * @type MessagePortManager
 */
Tizen.prototype.messageport = new MessagePortManager();

/************************ LocalMessagePort ***************************/
/**
 * Object LocalMessagePort()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/messageport.html
 *
 * @super Object
 * @constructor
 * @return {LocalMessagePort}
 */
function LocalMessagePort() {};
LocalMessagePort.prototype = new Object();
/**
 * Property messagePortName
 * @type String
 */
LocalMessagePort.prototype.messagePortName = new String();
/**
 * Property isTrusted
 * @type Boolean
 */
LocalMessagePort.prototype.isTrusted = new Boolean();
/**
 * function addMessagePortListener(listener) 
 *
 * @param {MessagePortCallback} listener
 * @type Number
 * @memberOf LocalMessagePort
 * @returns {Number}
 */
LocalMessagePort.prototype.addMessagePortListener = function(listener){ var ret = new Number(); return ret; };
/**
 * function removeMessagePortListener(watchId) 
 *
 * @param {Number} watchId
 * @type void
 * @memberOf LocalMessagePort
 * @returns {void}
 */
LocalMessagePort.prototype.removeMessagePortListener = function(watchId){ return; };

/************************ RemoteMessagePort ***************************/
/**
 * Object RemoteMessagePort()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/messageport.html
 *
 * @super Object
 * @constructor
 * @return {RemoteMessagePort}
 */
function RemoteMessagePort() {};
RemoteMessagePort.prototype = new Object();
/**
 * Property messagePortName
 * @type String
 */
RemoteMessagePort.prototype.messagePortName = new String();
/**
 * Property appId
 * @type ApplicationId
 */
RemoteMessagePort.prototype.appId = new ApplicationId();
/**
 * Property isTrusted
 * @type Boolean
 */
RemoteMessagePort.prototype.isTrusted = new Boolean();
/**
 * function sendMessage(data, localMessagePort)
 *
 * @param {array} data
 * @param {LocalMessagePort} localMessagePort
 * @type void
 * @memberOf RemoteMessagePort
 * @returns {void}
 */
RemoteMessagePort.prototype.sendMessage = function(data, localMessagePort){ return; };

/************************ MessagePortDataItem ***************************/

/************************ MessagePortCallback ***************************/
/**
 * Object MessagePortCallback()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/messageport.html
 *
 * @super Object
 * @constructor
 * @return {MessagePortCallback}
 */
function MessagePortCallback() {};
MessagePortCallback.prototype = new Object();
/**
 * function onreceived(data, remoteMessagePort)
 *
 * @param {array} data
 * @param {RemoteMessagePort} remoteMessagePort
 * @type void
 * @memberOf MessagePortCallback
 * @returns {void}
 */
MessagePortCallback.prototype.onreceived = function(data, remoteMessagePort){ return; };

/************************ SensorServiceManagerObject ***************************/
/**
 * Object SensorServiceManagerObject()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {SensorServiceManagerObject}
 */
function SensorServiceManagerObject() {};
SensorServiceManagerObject.prototype = new Object();
/**
 * Property sensorservice
 * @feature http://tizen.org/feature/sensor.photometer
 * @type SensorService
 */
SensorServiceManagerObject.prototype.sensorservice = new SensorService();

/************************ SensorServiceManagerObject ***************************/
/**
 * Object SensorServiceManagerObject()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {SensorService}
 */
function SensorService() {};
SensorService.prototype = new Object();
/**
 * function getDefaultSensor(type) 
 *
 * @param {SensorType} type
 * @type Sensor
 * @memberOf SensorService
 * @returns {Sensor}
 */
SensorService.prototype.getDefaultSensor = function(type){ var ret = new Sensor(); return ret; };
/**
 * function getAvailableSensors() 
 *
 * @type array
 * @memberOf SensorService
 * @returns {array}
 */
SensorService.prototype.getAvailableSensors = function(){ var ret = new array(); return ret; };
/**
 * Property sensorservice
 * @feature http://tizen.org/feature/sensor.photometer
 * @type SensorService
 */
Tizen.prototype.sensorservice = new SensorService();

/************************ Sensor ***************************/
/**
 * Object Sensor()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {Sensor}
 */
function Sensor() {};
Sensor.prototype = new Object();
/**
 * Property sensorType
 * @type SensorType
 */
Sensor.prototype.sensorType = new SensorType();
/**
 * function start(start)
 *
 * @param {SuccessCallback} successCallback
 * @param {ErrorCallback} errorCallback
 * @type void
 * @memberOf Sensor
 * @returns {void}
 */
Sensor.prototype.start = function(start){ return; };
/**
 * function stop()
 *
 * @type void
 * @memberOf Sensor
 * @returns {void}
 */
Sensor.prototype.stop = function(){ return; };
/**
 * function setChangeListener(successCallback)
 *
 * @param {SensorDataSuccessCallback} successCallback
 * @type void
 * @memberOf Sensor
 * @returns {void}
 */
Sensor.prototype.setChangeListener = function(successCallback){ return; };
/**
 * function unsetChangeListener()
 *
 * @type void
 * @memberOf Sensor
 * @returns {void}
 */
Sensor.prototype.unsetChangeListener = function(){ return; };

/************************ LightSensor ***************************/
/**
 * Object LightSensor()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {LightSensor}
 */
function LightSensor() {};
LightSensor.prototype = new Sensor();
/**
 * function getLightSensorData(successCallback, errorCallback)
 *
 * @param {SensorDataSuccessCallback} successCallback
 * @param {ErrorCallback} errorCallback
 * @type void
 * @memberOf LightSensor
 * @returns {void}
 */
LightSensor.prototype.getLightSensorData = function(successCallback, errorCallback){ return; };

/************************ MagneticSensor ***************************/
/**
 * Object MagneticSensor()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {MagneticSensor}
 */
function MagneticSensor() {};
MagneticSensor.prototype = new Sensor();
/**
 * function getMagneticSensorData(successCallback, errorCallback)
 *
 * @param {SensorDataSuccessCallback} successCallback
 * @param {ErrorCallback} errorCallback
 * @type void
 * @memberOf MagneticSensor
 * @returns {void}
 */
MagneticSensor.prototype.getMagneticSensorData = function(successCallback, errorCallback){ return; };

/************************ PressureSensor ***************************/
/**
 * Object PressureSensor()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {PressureSensor}
 */
function PressureSensor() {};
PressureSensor.prototype = new Sensor();
/**
 * function getPressureSensorData(successCallback, errorCallback)
 *
 * @param {SensorDataSuccessCallback} successCallback
 * @param {ErrorCallback} errorCallback
 * @type void
 * @memberOf PressureSensor
 * @returns {void}
 */
PressureSensor.prototype.getPressureSensorData = function(successCallback, errorCallback){ return; };

/************************ ProximitySensor ***************************/
/**
 * Object ProximitySensor()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {ProximitySensor}
 */
function ProximitySensor() {};
ProximitySensor.prototype = new Sensor();
/**
 * function getProximitySensorData(successCallback, errorCallback)
 *
 * @param {SensorDataSuccessCallback} successCallback
 * @param {ErrorCallback} errorCallback
 * @type void
 * @memberOf ProximitySensor
 * @returns {void}
 */
ProximitySensor.prototype.getProximitySensorData = function(successCallback, errorCallback){ return; };

/************************ UltravioletSensor ***************************/
/**
 * Object UltravioletSensor()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {UltravioletSensor}
 */
function UltravioletSensor() {};
UltravioletSensor.prototype = new Sensor();
/**
 * function getUltravioletSensorData(successCallback, errorCallback)
 *
 * @param {SensorDataSuccessCallback} successCallback
 * @param {ErrorCallback} errorCallback
 * @type void
 * @memberOf UltravioletSensor
 * @returns {void}
 */
UltravioletSensor.prototype.getUltravioletSensorData = function(successCallback, errorCallback){ return; };

/************************ HRMRawSensor ***************************/
/**
 * Object HRMRawSensor()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {HRMRawSensor}
 */
function HRMRawSensor() {};
HRMRawSensor.prototype = new Sensor();
/**
 * function getHRMRawSensorData(successCallback, errorCallback)
 *
 * @param {SensorDataSuccessCallback} successCallback
 * @param {ErrorCallback} errorCallback
 * @type void
 * @memberOf HRMRawSensor
 * @returns {void}
 */
HRMRawSensor.prototype.getHRMRawSensorData = function(successCallback, errorCallback){ return; };

/************************ SensorData ***************************/
/**
 * Object SensorData()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {SensorData}
 */
function SensorData() {};
SensorData.prototype = new Object();

/************************ SensorLightData ***************************/
/**
 * Object SensorLightData()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {SensorLightData}
 */
function SensorLightData() {};
SensorLightData.prototype = new SensorData();
/**
 * Property lightLevel
 * @type Number
 */
SensorLightData.prototype.lightLevel = new Number();

/************************ SensorMagneticData ***************************/
/**
 * Object SensorMagneticData()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {SensorMagneticData}
 */
function SensorMagneticData() {};
SensorMagneticData.prototype = new SensorData();
/**
 * Property x
 * @type Number
 */
SensorMagneticData.prototype.x = new Number();
/**
 * Property y
 * @type Number
 */
SensorMagneticData.prototype.y = new Number();
/**
 * Property z
 * @type Number
 */
SensorMagneticData.prototype.z = new Number();
/**
 * Property accuracy
 * @type MagneticSensorAccuracy
 */
SensorMagneticData.prototype.accuracy = new MagneticSensorAccuracy();

/************************ SensorPressureData ***************************/
/**
 * Object SensorPressureData()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {SensorPressureData}
 */
function SensorPressureData() {};
SensorPressureData.prototype = new SensorData();
/**
 * Property pressure
 * @type Number
 */
SensorPressureData.prototype.pressure = new Number();

/************************ SensorProximityData ***************************/
/**
 * Object SensorProximityData()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {SensorProximityData}
 */
function SensorProximityData() {};
SensorProximityData.prototype = new SensorData();
/**
 * Property pressure
 * @type ProximityState
 */
SensorProximityData.prototype.proximityState = new ProximityState();

/************************ SensorUltravioletData ***************************/
/**
 * Object SensorUltravioletData()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {SensorUltravioletData}
 */
function SensorUltravioletData() {};
SensorUltravioletData.prototype = new SensorData();
/**
 * Property ultravioletLevel
 * @type Number
 */
SensorUltravioletData.prototype.ultravioletLevel = new Number();

/************************ SensorHRMRawData ***************************/
/**
 * Object SensorHRMRawData()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {SensorHRMRawData}
 */
function SensorHRMRawData() {};
SensorHRMRawData.prototype = new SensorData();
/**
 * Property lightType
 * @type String
 */
SensorHRMRawData.prototype.lightType = new String();
/**
 * Property lightIntensity
 * @type Number
 */
SensorHRMRawData.prototype.lightIntensity = new Number();

/************************ SensorDataSuccessCallback ***************************/
/**
 * Object SensorDataSuccessCallback()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/sensor.html
 *
 * @super Object
 * @constructor
 * @return {SensorDataSuccessCallback}
 */
function SensorDataSuccessCallback() {};
SensorDataSuccessCallback.prototype = new Object();
/**
 * function onsuccess(sensorData)
 *
 * @param {SensorData} sensorData
 * @type void
 * @memberOf SensorDataSuccessCallback
 * @returns {void}
 */
SensorDataSuccessCallback.prototype.onsuccess = function(sensorData){ return; };

/************************ SystemInfoObject ***************************/
/**
 * Object SystemInfoObject()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoObject}
 */
function SystemInfoObject() {};
SystemInfoObject.prototype = new Object();
/**
 * Property systeminfo
 * @feature http://tizen.org/feature/network.wifi
 * @type SystemInfo
 */
SystemInfoObject.prototype.systeminfo = new SystemInfo();

/************************ SystemInfo ***************************/
/**
 * Object SystemInfo()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfo}
 */
function SystemInfo() {};
SystemInfo.prototype = new Object();
/**
 * function getTotalMemory()
 *
 * @type Number
 * @memberOf SystemInfo
 * @returns {Number}
 */
SystemInfo.prototype.getTotalMemory = function(){ var ret = new Number(); return ret; };
/**
 * function getAvailableMemory()
 *
 * @type Number
 * @memberOf SystemInfo
 * @returns {Number}
 */
SystemInfo.prototype.getAvailableMemory = function(){ var ret = new Number(); return ret; };
/**
 * function getCapabilities()
 *
 * @type SystemInfoDeviceCapability
 * @memberOf SystemInfo
 * @returns {SystemInfoDeviceCapability}
 */
SystemInfo.prototype.getCapabilities = function(){ var ret = new SystemInfoDeviceCapability(); return ret; };
/**
 * function getCapability(key)
 *
 * @param {String} key
 * @type any
 * @memberOf SystemInfo
 * @returns {any}
 */
SystemInfo.prototype.getCapability = function(key){ var ret = new any(); return ret; };
/**
 * function getCount(property)
 *
 * @param {SystemInfoPropertyId} property
 * @type Number
 * @memberOf SystemInfo
 * @returns {Number}
 */
SystemInfo.prototype.getCount = function(property){ var ret = new Number(); return ret; };
/**
 * function getPropertyValue(property, successCallback, errorCallback)
 *
 * @param {SystemInfoPropertyId} property
 * @param {SystemInfoPropertySuccessCallback} successCallback
 * @param {ErrorCallback} errorCallback
 * @type void
 * @memberOf SystemInfo
 * @returns {void}
 */
SystemInfo.prototype.getPropertyValue = function(property, successCallback, errorCallback){ return; };
/**
 * function getPropertyValueArray(property, successCallback, errorCallback)
 *
 * @param {SystemInfoPropertyId} property
 * @param {SystemInfoPropertyArraySuccessCallback} successCallback
 * @param {ErrorCallback} errorCallback
 * @type void
 * @memberOf SystemInfo
 * @returns {void}
 */
SystemInfo.prototype.getPropertyValueArray = function(property, successCallback, errorCallback){ return; };
/**
 * function addPropertyValueChangeListener(property, successCallback, options, errorCallback)
 *
 * @param {SystemInfoPropertyId} property
 * @param {SystemInfoPropertySuccessCallback} successCallback
 * @param {SystemInfoOptions} options
 * @param {ErrorCallback} errorCallback
 * @type Number
 * @memberOf SystemInfo
 * @returns {Number}
 */
SystemInfo.prototype.addPropertyValueChangeListener = function(property, successCallback, options, errorCallback){ var ret = new Number(); return ret; };
/**
 * function addPropertyValueArrayChangeListener(property, successCallback, options, errorCallback)
 *
 * @param {SystemInfoPropertyId} property
 * @param {SystemInfoPropertyArraySuccessCallback} successCallback
 * @param {SystemInfoOptions} options
 * @param {ErrorCallback} errorCallback
 * @type Number
 * @memberOf SystemInfo
 * @returns {Number}
 */
SystemInfo.prototype.addPropertyValueArrayChangeListener = function(property, successCallback, options, errorCallback){ var ret = new Number(); return ret; };
/**
 * function removePropertyValueChangeListener(listenerId)
 *
 * @param {Number} listenerId
 * @type void
 * @memberOf SystemInfo
 * @returns {void}
 */
SystemInfo.prototype.removePropertyValueChangeListener = function(listenerId){ return; };
/**
 * Property systeminfo
 * @feature http://tizen.org/feature/network.wifi
 * @type SystemInfo
 */
Tizen.prototype.systeminfo = new SystemInfo();

/************************ SystemInfoDeviceCapability ***************************/
/**
 * Object SystemInfoDeviceCapability()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoDeviceCapability}
 */
function SystemInfoDeviceCapability() {};
SystemInfoDeviceCapability.prototype = new Object();
/**
 * Property bluetooth
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.bluetooth = new Boolean();
/**
 * Property nfc
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.nfc = new Boolean();
/**
 * Property nfcReservedPush
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.nfcReservedPush = new Boolean();
/**
 * Property multiTouchCount
 * @type Number
 */
SystemInfoDeviceCapability.prototype.multiTouchCount = new Number();
/**
 * Property inputKeyboard
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.inputKeyboard = new Boolean();
/**
 * Property inputKeyboardLayout
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.inputKeyboardLayout = new Boolean();
/**
 * Property wifi
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.wifi = new Boolean();
/**
 * Property wifiDirect
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.wifiDirect = new Boolean();
/**
 * Property opengles
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.opengles = new Boolean();
/**
 * Property openglestextureFormat
 * @type String
 */
SystemInfoDeviceCapability.prototype.openglestextureFormat = new String();
/**
 * Property openglesVersion1_1
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.openglesVersion1_1 = new Boolean();
/**
 * Property openglesVersion2_0
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.openglesVersion2_0 = new Boolean();
/**
 * Property fmRadio
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.fmRadio = new Boolean();
/**
 * Property platformVersion
 * @type String
 */
SystemInfoDeviceCapability.prototype.platformVersion = new String();
/**
 * Property webApiVersion
 * @type String
 */
SystemInfoDeviceCapability.prototype.webApiVersion = new String();
/**
 * Property nativeApiVersion
 * @type String
 */
SystemInfoDeviceCapability.prototype.nativeApiVersion = new String();
/**
 * Property platformName
 * @type String
 */
SystemInfoDeviceCapability.prototype.platformName = new String();
/**
 * Property camera
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.camera = new Boolean();
/**
 * Property cameraFront
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.cameraFront = new Boolean();
/**
 * Property cameraFrontFlash
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.cameraFrontFlash = new Boolean();
/**
 * Property cameraBack
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.cameraBack = new Boolean();
/**
 * Property cameraBackFlash
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.cameraBackFlash = new Boolean();
/**
 * Property location
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.location = new Boolean();
/**
 * Property locationGps
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.locationGps = new Boolean();
/**
 * Property locationWps
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.locationWps = new Boolean();
/**
 * Property microphone
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.microphone = new Boolean();
/**
 * Property usbHost
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.usbHost = new Boolean();
/**
 * Property usbAccessory
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.usbAccessory = new Boolean();
/**
 * Property screenOutputRca
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.screenOutputRca = new Boolean();
/**
 * Property screenOutputHdmi
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.screenOutputHdmi = new Boolean();
/**
 * Property platformCoreCpuArch
 * @type String
 */
SystemInfoDeviceCapability.prototype.platformCoreCpuArch = new String();
/**
 * Property platformCoreFpuArch
 * @type String
 */
SystemInfoDeviceCapability.prototype.platformCoreFpuArch = new String();
/**
 * Property sipVoip
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.sipVoip = new Boolean();
/**
 * Property duid
 * @type String
 */
SystemInfoDeviceCapability.prototype.duid = new String();
/**
 * Property speechRecognition
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.speechRecognition = new Boolean();
/**
 * Property speechSynthesis
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.speechSynthesis = new Boolean();
/**
 * Property accelerometer
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.accelerometer = new Boolean();
/**
 * Property accelerometerWakeup
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.accelerometerWakeup = new Boolean();
/**
 * Property barometer
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.barometer = new Boolean();
/**
 * Property barometerWakeup
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.barometerWakeup = new Boolean();
/**
 * Property gyroscope
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.gyroscope = new Boolean();
/**
 * Property gyroscopeWakeup
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.gyroscopeWakeup = new Boolean();
/**
 * Property magnetometer
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.magnetometer = new Boolean();
/**
 * Property magnetometerWakeup
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.magnetometerWakeup = new Boolean();
/**
 * Property photometer
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.photometer = new Boolean();
/**
 * Property photometerWakeup
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.photometerWakeup = new Boolean();
/**
 * Property proximity
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.proximity = new Boolean();
/**
 * Property proximityWakeup
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.proximityWakeup = new Boolean();
/**
 * Property tiltmeter
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.tiltmeter = new Boolean();
/**
 * Property tiltmeterWakeup
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.tiltmeterWakeup = new Boolean();
/**
 * Property dataEncryption
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.dataEncryption = new Boolean();
/**
 * Property graphicsAcceleration
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.graphicsAcceleration = new Boolean();
/**
 * Property push
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.push = new Boolean();
/**
 * Property telephony
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.telephony = new Boolean();
/**
 * Property telephonyMms
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.telephonyMms = new Boolean();
/**
 * Property telephonySms
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.telephonySms = new Boolean();
/**
 * Property screenSizeNormal
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.screenSizeNormal = new Boolean();
/**
 * Property screenSize480_800
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.screenSize480_800 = new Boolean();
/**
 * Property screenSize720_1280
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.screenSize720_1280 = new Boolean();
/**
 * Property autoRotation
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.autoRotation = new Boolean();
/**
 * Property shellAppWidget
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.shellAppWidget = new Boolean();
/**
 * Property visionImageRecognition
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.visionImageRecognition = new Boolean();
/**
 * Property visionQrcodeGeneration
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.visionQrcodeGeneration = new Boolean();
/**
 * Property visionQrcodeRecognition
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.visionQrcodeRecognition = new Boolean();
/**
 * Property visionFaceRecognition
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.visionFaceRecognition = new Boolean();
/**
 * Property secureElement
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.secureElement = new Boolean();
/**
 * Property nativeOspCompatible
 * @type Boolean
 */
SystemInfoDeviceCapability.prototype.nativeOspCompatible = new Boolean();
/**
 * Property profile
 * @type SystemInfoProfile
 */
SystemInfoDeviceCapability.prototype.profile = new SystemInfoProfile();


/************************ SystemInfoOptions ***************************/

/************************ SystemInfoPropertySuccessCallback ***************************/
/**
 * Object SystemInfoPropertySuccessCallback()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoPropertySuccessCallback}
 */
function SystemInfoPropertySuccessCallback() {};
SystemInfoPropertySuccessCallback.prototype = new Object();
/**
 * function onsuccess(data)
 *
 * @param {SystemInfoProperty} property
 * @type void
 * @memberOf SystemInfoPropertySuccessCallback
 * @returns {void}
 */
SystemInfoPropertySuccessCallback.prototype.onsuccess = function(data){ return; };

/************************ SystemInfoPropertyArraySuccessCallback ***************************/
/**
 * Object SystemInfoPropertyArraySuccessCallback()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoPropertyArraySuccessCallback}
 */
function SystemInfoPropertyArraySuccessCallback() {};
SystemInfoPropertyArraySuccessCallback.prototype = new Object();
/**
 * function onsuccess(properties)
 *
 * @param {array} properties
 * @type void
 * @memberOf SystemInfoPropertyArraySuccessCallback
 * @returns {void}
 */
SystemInfoPropertyArraySuccessCallback.prototype.onsuccess = function(properties){ return; };

/************************ SystemInfoProperty ***************************/
/**
 * Object SystemInfoProperty()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoProperty}
 */
function SystemInfoProperty() {};
SystemInfoProperty.prototype = new Object();

/************************ SystemInfoBattery ***************************/
/**
 * Object SystemInfoBattery()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoBattery}
 */
function SystemInfoBattery() {};
SystemInfoBattery.prototype = new SystemInfoProperty();
/**
 * Property level
 * @type Number
 */
SystemInfoBattery.prototype.level = new Number();
/**
 * Property isCharging
 * @type Boolean
 */
SystemInfoBattery.prototype.isCharging = new Boolean();

/************************ SystemInfoCpu ***************************/
/**
 * Object SystemInfoCpu()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoCpu}
 */
function SystemInfoCpu() {};
SystemInfoCpu.prototype = new SystemInfoProperty();
/**
 * Property load
 * @type Number
 */
SystemInfoCpu.prototype.load = new Number();

/************************ SystemInfoStorage ***************************/
/**
 * Object SystemInfoStorage()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoStorage}
 */
function SystemInfoStorage() {};
SystemInfoStorage.prototype = new SystemInfoProperty();
/**
 * Property units
 * @type array
 */
SystemInfoStorage.prototype.units = new array();

/************************ SystemInfoStorageUnit ***************************/
/**
 * Object SystemInfoStorageUnit()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoStorageUnit}
 */
function SystemInfoStorageUnit() {};
SystemInfoStorageUnit.prototype = new SystemInfoProperty();
/**
 * Property type
 * @type String
 */
SystemInfoStorageUnit.prototype.type = new String();
/**
 * Property capacity
 * @type Number
 */
SystemInfoStorageUnit.prototype.capacity = new Number();
/**
 * Property availableCapacity
 * @type Number
 */
SystemInfoStorageUnit.prototype.availableCapacity = new Number();
/**
 * Property isRemovable
 * @type Boolean
 */
SystemInfoStorageUnit.prototype.isRemovable = new Boolean();
/**
 * Property isRemoveable
 * @type Boolean
 */
SystemInfoStorageUnit.prototype.isRemoveable = new Boolean();

/************************ SystemInfoDisplay ***************************/
/**
 * Object SystemInfoDisplay()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoDisplay}
 */
function SystemInfoDisplay() {};
SystemInfoDisplay.prototype = new SystemInfoProperty();
/**
 * Property resolutionWidth
 * @type Number
 */
SystemInfoDisplay.prototype.resolutionWidth = new Number();
/**
 * Property resolutionHeight
 * @type Number
 */
SystemInfoDisplay.prototype.resolutionHeight = new Number();
/**
 * Property dotsPerInchWidth
 * @type Number
 */
SystemInfoDisplay.prototype.dotsPerInchWidth = new Number();
/**
 * Property dotsPerInchHeight
 * @type Number
 */
SystemInfoDisplay.prototype.dotsPerInchHeight = new Number();
/**
 * Property physicalWidth
 * @type Number
 */
SystemInfoDisplay.prototype.physicalWidth = new Number();
/**
 * Property physicalHeight
 * @type Number
 */
SystemInfoDisplay.prototype.physicalHeight = new Number();
/**
 * Property brightness
 * @type Number
 */
SystemInfoDisplay.prototype.brightness = new Number();

/************************ SystemInfoDeviceOrientation ***************************/
/**
 * Object SystemInfoDeviceOrientation()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoDeviceOrientation}
 */
function SystemInfoDeviceOrientation() {};
SystemInfoDeviceOrientation.prototype = new SystemInfoProperty();
/**
 * Property status
 * @type SystemInfoDeviceOrientationStatus
 */
SystemInfoDeviceOrientation.prototype.status = new SystemInfoDeviceOrientationStatus();
/**
 * Property isAutoRotation
 * @type Boolean
 */
SystemInfoDeviceOrientation.prototype.isAutoRotation = new Boolean();

/************************ SystemInfoBuild ***************************/
/**
 * Object SystemInfoBuild()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoBuild}
 */
function SystemInfoBuild() {};
SystemInfoBuild.prototype = new SystemInfoProperty();
/**
 * Property model
 * @type String
 */
SystemInfoBuild.prototype.model = new String();
/**
 * Property manufacturer
 * @type String
 */
SystemInfoBuild.prototype.manufacturer = new String();
/**
 * Property buildVersion
 * @type String
 */
SystemInfoBuild.prototype.buildVersion = new String();

/************************ SystemInfoLocale ***************************/
/**
 * Object SystemInfoLocale()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoLocale}
 */
function SystemInfoLocale() {};
SystemInfoLocale.prototype = new SystemInfoProperty();
/**
 * Property language
 * @type String
 */
SystemInfoLocale.prototype.language = new String();
/**
 * Property country
 * @type String
 */
SystemInfoLocale.prototype.country = new String();

/************************ SystemInfoNetwork ***************************/
/**
 * Object SystemInfoNetwork()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoNetwork}
 */
function SystemInfoNetwork() {};
SystemInfoNetwork.prototype = new SystemInfoProperty();
/**
 * Property networkType
 * @type SystemInfoNetworkType
 */
SystemInfoNetwork.prototype.networkType = new SystemInfoNetworkType();

/************************ SystemInfoWifiNetwork ***************************/
/**
 * Object SystemInfoWifiNetwork()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoWifiNetwork}
 */
function SystemInfoWifiNetwork() {};
SystemInfoWifiNetwork.prototype = new SystemInfoProperty();
/**
 * Property status
 * @type String
 */
SystemInfoWifiNetwork.prototype.status = new String();
/**
 * Property ssid
 * @type String
 */
SystemInfoWifiNetwork.prototype.ssid = new String();
/**
 * Property ipAddress
 * @type String
 */
SystemInfoWifiNetwork.prototype.ipAddress = new String();
/**
 * Property ipv6Address
 * @type String
 */
SystemInfoWifiNetwork.prototype.ipv6Address = new String();
/**
 * Property macAddress
 * @type String
 */
SystemInfoWifiNetwork.prototype.macAddress = new String();
/**
 * Property signalStrength
 * @type Number
 */
SystemInfoWifiNetwork.prototype.signalStrength = new Number();

/************************ SystemInfoCellularNetwork ***************************/
/**
 * Object SystemInfoCellularNetwork()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoCellularNetwork}
 */
function SystemInfoCellularNetwork() {};
SystemInfoCellularNetwork.prototype = new SystemInfoProperty();
/**
 * Property status
 * @type String
 */
SystemInfoCellularNetwork.prototype.status = new String();
/**
 * Property apn
 * @type String
 */
SystemInfoCellularNetwork.prototype.apn = new String();
/**
 * Property ipAddress
 * @type String
 */
SystemInfoCellularNetwork.prototype.ipAddress = new String();
/**
 * Property ipv6Address
 * @type String
 */
SystemInfoCellularNetwork.prototype.ipv6Address = new String();
/**
 * Property mcc
 * @type Number
 */
SystemInfoCellularNetwork.prototype.mcc = new Number();
/**
 * Property mnc
 * @type Number
 */
SystemInfoCellularNetwork.prototype.mnc = new Number();
/**
 * Property cellId
 * @type Number
 */
SystemInfoCellularNetwork.prototype.cellId = new Number();
/**
 * Property lac
 * @type Number
 */
SystemInfoCellularNetwork.prototype.lac = new Number();
/**
 * Property isRoaming
 * @type Boolean
 */
SystemInfoCellularNetwork.prototype.isRoaming = new Boolean();
/**
 * Property isFlightMode
 * @type Boolean
 */
SystemInfoCellularNetwork.prototype.isFlightMode = new Boolean();
/**
 * Property imei
 * @type String
 */
SystemInfoCellularNetwork.prototype.imei = new String();

/************************ SystemInfoSIM ***************************/
/**
 * Object SystemInfoSIM()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoSIM}
 */
function SystemInfoSIM() {};
SystemInfoSIM.prototype = new SystemInfoProperty();
/**
 * Property state
 * @type SystemInfoSimState
 */
SystemInfoSIM.prototype.state = new SystemInfoSimState();
/**
 * Property operatorName
 * @type String
 */
SystemInfoSIM.prototype.operatorName = new String();
/**
 * Property msisdn
 * @type String
 */
SystemInfoSIM.prototype.msisdn = new String();
/**
 * Property iccid
 * @type String
 */
SystemInfoSIM.prototype.iccid = new String();
/**
 * Property mcc
 * @type Number
 */
SystemInfoSIM.prototype.mcc = new Number();
/**
 * Property mnc
 * @type Number
 */
SystemInfoSIM.prototype.mnc = new Number();
/**
 * Property msin
 * @type String
 */
SystemInfoSIM.prototype.msin = new String();
/**
 * Property spn
 * @type String
 */
SystemInfoSIM.prototype.spn = new String();

/************************ SystemInfoPeripheral ***************************/
/**
 * Object SystemInfoPeripheral()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoPeripheral}
 */
function SystemInfoPeripheral() {};
SystemInfoPeripheral.prototype = new SystemInfoProperty();
/**
 * Property isVideoOutputOn
 * @type Boolean
 */
SystemInfoPeripheral.prototype.isVideoOutputOn = new Boolean();

/************************ SystemInfoMemory ***************************/
/**
 * Object SystemInfoMemory()
 * https://developer.tizen.org/dev-guide/2.3.1/org.tizen.web.apireference/html/device_api/wearable/tizen/systeminfo.html
 *
 * @super Object
 * @constructor
 * @return {SystemInfoMemory}
 */
function SystemInfoMemory() {};
SystemInfoMemory.prototype = new SystemInfoProperty();
/**
 * Property status
 * @type SystemInfoLowMemoryStatus
 */
SystemInfoMemory.prototype.status = new SystemInfoLowMemoryStatus();

Window.prototype.tizen = new Tizen();
