/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.input;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.LogUtil;

public class TouchGestureController
implements Initializable {
    private static Logger logger = LogUtil.getECPLogger(TouchGestureController.class).getLogger();
    private static int GESTURE_HWKEY = 1;
    @FXML
    private Button flickUpBtn;
    @FXML
    private Button flickDownBtn;

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.flickUpBtn.setStyle("-fx-padding: 0 0 0 0;");
        this.flickDownBtn.setStyle("-fx-padding: 0 0 0 0;");
    }

    private void sendGestureEvent(int n, String string) {
        MessageSender.getInstance().sendDeviceReq("TGesture", n, 0, string);
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException interruptedException) {
            logger.warning(interruptedException.getMessage());
        }
    }

    @FXML
    public void flickUpMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getEventType() == MouseEvent.MOUSE_CLICKED) {
            logger.info("flick up is selected");
            this.sendGestureEvent(GESTURE_HWKEY, "1#169#");
            this.sendGestureEvent(GESTURE_HWKEY, "2#169#");
        }
    }

    @FXML
    public void flickDownMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getEventType() == MouseEvent.MOUSE_CLICKED) {
            logger.info("flick down is selected");
            this.sendGestureEvent(GESTURE_HWKEY, "1#158#");
            this.sendGestureEvent(GESTURE_HWKEY, "2#158#");
        }
    }
}

