/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes_util;

import com.ibm.wala.cast.js.html.IHtmlCallback;
import com.ibm.wala.cast.js.html.IHtmlParser;
import com.ibm.wala.cast.js.html.ITag;
import com.ibm.wala.cast.js.html.IUrlResolver;
import com.ibm.wala.cast.js.html.SourceRegion;
import com.ibm.wala.cast.js.html.WebUtil;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.util.collections.Pair;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;
import java.util.regex.Pattern;

public class DomSimpleSourceExtractor {
    private static final Pattern LEGAL_JS_IDENTIFIER_REGEXP = Pattern.compile("[a-zA-Z$_][a-zA-Z\\d$_]*");

    public static String getScriptName(String file) throws MalformedURLException {
        int lastIdxOfSlash = file.lastIndexOf(47);
        file = lastIdxOfSlash == -1 ? file : file.substring(lastIdxOfSlash + 1);
        return file;
    }

    public void extractScripts(URL entrypointUrl, IHtmlParser htmlParser, IUrlResolver urlResolver) throws IOException {
        InputStream inputStreamReader = WebUtil.getStream((URL)entrypointUrl);
        IGeneratorCallback htmlCallback = this.createHtmlCallback(entrypointUrl, urlResolver);
        htmlParser.parse(entrypointUrl, inputStreamReader, (IHtmlCallback)htmlCallback, entrypointUrl.getFile());
    }

    protected IGeneratorCallback createHtmlCallback(URL entrypointUrl, IUrlResolver urlResolver) {
        return new HtmlCallback(entrypointUrl, urlResolver);
    }

    protected static class HtmlCallback
    implements IGeneratorCallback {
        protected final URL entrypointUrl;
        protected final IUrlResolver urlResolver;
        protected final SourceRegion scriptRegion;
        protected final SourceRegion domRegion;
        protected final SourceRegion entrypointRegion;
        private ITag currentScriptTag;
        private int nodeCounter = 0;
        private int scriptNodeCounter = 0;

        public HtmlCallback(URL entrypointUrl, IUrlResolver urlResolver) {
            this.entrypointUrl = entrypointUrl;
            this.urlResolver = urlResolver;
            this.scriptRegion = new SourceRegion();
            this.domRegion = new SourceRegion();
            this.entrypointRegion = new SourceRegion();
        }

        protected CAstSourcePositionMap.Position makePos(int lineNumber, ITag governingTag) {
            return this.makePos(this.entrypointUrl, lineNumber, governingTag);
        }

        protected CAstSourcePositionMap.Position makePos(URL url, int lineNumber, ITag governingTag) {
            return governingTag.getElementPosition();
        }

        public void handleEndTag(ITag tag) {
            if (tag.getName().equalsIgnoreCase("script")) {
                assert (this.currentScriptTag != null);
                this.currentScriptTag = null;
            }
        }

        public void handleText(CAstSourcePositionMap.Position p, String text) {
            if (this.currentScriptTag != null) {
                URL url = this.entrypointUrl;
                try {
                    url = new URL(this.entrypointUrl, "#" + this.scriptNodeCounter);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                text = text.replaceAll("[^\\x00-\\x7F]", "");
                text = text.replaceAll("(?s)<!--.*?-->", "");
                text = text.trim();
                if (text.startsWith("<![CDATA[")) {
                    assert (text.endsWith("]]>"));
                    text = text.substring(9, text.indexOf("]]>"));
                }
                if (!text.trim().isEmpty()) {
                    this.writeToFile(url, p, text);
                }
            }
        }

        public void handleStartTag(ITag tag) {
            if (tag.getName().equalsIgnoreCase("script") && tag.getAttributeByName("type") != null && ((String)tag.getAttributeByName((String)"type").fst).equals("text/javascript")) {
                assert (this.currentScriptTag == null);
                this.currentScriptTag = tag;
                ++this.scriptNodeCounter;
            }
            this.handleDOM(tag);
        }

        protected void handleDOM(ITag tag) {
            Pair idAttribute = tag.getAttributeByName("id");
            String funcName = idAttribute != null && LEGAL_JS_IDENTIFIER_REGEXP.matcher((CharSequence)idAttribute.fst).matches() ? (String)idAttribute.fst : "node" + this.nodeCounter++;
            this.handleDOM(tag, funcName);
        }

        protected void handleDOM(ITag tag, String funcName) {
            Map attributeSet = tag.getAllAttributes();
            for (Map.Entry<String, Pair<String, CAstSourcePositionMap.Position>> entry : attributeSet.entrySet()) {
                this.handleAttribute(entry, funcName, tag);
            }
        }

        private void handleAttribute(Map.Entry<String, Pair<String, CAstSourcePositionMap.Position>> a, String funcName, ITag tag) {
            URL url = this.entrypointUrl;
            try {
                url = new URL(this.entrypointUrl, "#" + tag.getElementPosition().getFirstOffset());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            CAstSourcePositionMap.Position pos = (CAstSourcePositionMap.Position)a.getValue().snd;
            String attName = a.getKey();
            String attValue = (String)a.getValue().fst;
            if (attName.toLowerCase().startsWith("on") || attValue != null && attValue.toLowerCase().startsWith("javascript:")) {
                String fName = tag.getName().toLowerCase() + "_" + attName + "_" + funcName;
                String signatureLine = "function " + fName + "(event) {";
                this.domRegion.println(signatureLine + "\n" + this.extructJS(attValue) + "\n}", pos, url);
                this.entrypointRegion.println("\t" + fName + "(null);", pos, url);
            }
        }

        private String extructJS(String attValue) {
            if (attValue == null) {
                return "";
            }
            String content = attValue.toLowerCase().equals("javascript:") ? attValue.substring("javascript:".length()) : attValue;
            return content;
        }

        @Override
        public void writeToFinalRegion(SourceRegion finalRegion) {
            finalRegion.write(this.scriptRegion);
        }

        private void writeToFile(URL entrypointUrl, CAstSourcePositionMap.Position p, String text) {
            String outputFileName = null;
            try {
                outputFileName = URLDecoder.decode(entrypointUrl.getFile(), "UTF-8");
                String extension = outputFileName.substring(outputFileName.lastIndexOf("."), outputFileName.length());
                outputFileName = outputFileName.substring(0, outputFileName.lastIndexOf(".")) + extension + "." + p.getFirstLine() + "_" + p.getLastLine() + ".js";
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (outputFileName != null) {
                File outputFile = new File(outputFileName);
                try {
                    BufferedWriter bufferedWriter;
                    if (!outputFile.exists()) {
                        FileWriter fileWriter = new FileWriter(outputFile);
                        bufferedWriter = new BufferedWriter(fileWriter);
                        for (int i = 0; i < p.getFirstLine() - 1; ++i) {
                            bufferedWriter.newLine();
                        }
                    } else {
                        FileWriter fileWriter = new FileWriter(outputFile, true);
                        bufferedWriter = new BufferedWriter(fileWriter);
                    }
                    bufferedWriter.write(text);
                    bufferedWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected static interface IGeneratorCallback
    extends IHtmlCallback {
        public void writeToFinalRegion(SourceRegion var1);
    }
}

