/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.nodes;

import edu.rice.cs.plt.tuple.Option;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import kr.ac.kaist.jsaf.nodes.WAnyType;
import kr.ac.kaist.jsaf.nodes.WArgument;
import kr.ac.kaist.jsaf.nodes.WArrayType;
import kr.ac.kaist.jsaf.nodes.WAttribute;
import kr.ac.kaist.jsaf.nodes.WBoolean;
import kr.ac.kaist.jsaf.nodes.WCallback;
import kr.ac.kaist.jsaf.nodes.WConst;
import kr.ac.kaist.jsaf.nodes.WDefinition;
import kr.ac.kaist.jsaf.nodes.WDictionary;
import kr.ac.kaist.jsaf.nodes.WDictionaryMember;
import kr.ac.kaist.jsaf.nodes.WEAArray;
import kr.ac.kaist.jsaf.nodes.WEAAttribute;
import kr.ac.kaist.jsaf.nodes.WEACallback;
import kr.ac.kaist.jsaf.nodes.WEACallbackFunctionOnly;
import kr.ac.kaist.jsaf.nodes.WEAConst;
import kr.ac.kaist.jsaf.nodes.WEAConstructor;
import kr.ac.kaist.jsaf.nodes.WEACreator;
import kr.ac.kaist.jsaf.nodes.WEADeleter;
import kr.ac.kaist.jsaf.nodes.WEADictionary;
import kr.ac.kaist.jsaf.nodes.WEAEllipsis;
import kr.ac.kaist.jsaf.nodes.WEAEnum;
import kr.ac.kaist.jsaf.nodes.WEAException;
import kr.ac.kaist.jsaf.nodes.WEAGetter;
import kr.ac.kaist.jsaf.nodes.WEAImplements;
import kr.ac.kaist.jsaf.nodes.WEAInherit;
import kr.ac.kaist.jsaf.nodes.WEAInterface;
import kr.ac.kaist.jsaf.nodes.WEALegacycaller;
import kr.ac.kaist.jsaf.nodes.WEANoInterfaceObject;
import kr.ac.kaist.jsaf.nodes.WEAOptional;
import kr.ac.kaist.jsaf.nodes.WEAPartial;
import kr.ac.kaist.jsaf.nodes.WEAQuestion;
import kr.ac.kaist.jsaf.nodes.WEAReadonly;
import kr.ac.kaist.jsaf.nodes.WEASetter;
import kr.ac.kaist.jsaf.nodes.WEAStatic;
import kr.ac.kaist.jsaf.nodes.WEAString;
import kr.ac.kaist.jsaf.nodes.WEAStringifier;
import kr.ac.kaist.jsaf.nodes.WEATypedef;
import kr.ac.kaist.jsaf.nodes.WEAUnrestricted;
import kr.ac.kaist.jsaf.nodes.WEAttribute;
import kr.ac.kaist.jsaf.nodes.WEnum;
import kr.ac.kaist.jsaf.nodes.WException;
import kr.ac.kaist.jsaf.nodes.WExceptionField;
import kr.ac.kaist.jsaf.nodes.WExceptionMember;
import kr.ac.kaist.jsaf.nodes.WFloat;
import kr.ac.kaist.jsaf.nodes.WId;
import kr.ac.kaist.jsaf.nodes.WImplementsStatement;
import kr.ac.kaist.jsaf.nodes.WInteger;
import kr.ac.kaist.jsaf.nodes.WInterface;
import kr.ac.kaist.jsaf.nodes.WInterfaceMember;
import kr.ac.kaist.jsaf.nodes.WLiteral;
import kr.ac.kaist.jsaf.nodes.WModule;
import kr.ac.kaist.jsaf.nodes.WNamedType;
import kr.ac.kaist.jsaf.nodes.WNode;
import kr.ac.kaist.jsaf.nodes.WNull;
import kr.ac.kaist.jsaf.nodes.WOperation;
import kr.ac.kaist.jsaf.nodes.WQCreator;
import kr.ac.kaist.jsaf.nodes.WQDeleter;
import kr.ac.kaist.jsaf.nodes.WQGetter;
import kr.ac.kaist.jsaf.nodes.WQId;
import kr.ac.kaist.jsaf.nodes.WQLegacycaller;
import kr.ac.kaist.jsaf.nodes.WQSetter;
import kr.ac.kaist.jsaf.nodes.WQStatic;
import kr.ac.kaist.jsaf.nodes.WQualifier;
import kr.ac.kaist.jsaf.nodes.WSequenceType;
import kr.ac.kaist.jsaf.nodes.WString;
import kr.ac.kaist.jsaf.nodes.WTSArray;
import kr.ac.kaist.jsaf.nodes.WTSQuestion;
import kr.ac.kaist.jsaf.nodes.WType;
import kr.ac.kaist.jsaf.nodes.WTypeSuffix;
import kr.ac.kaist.jsaf.nodes.WTypedef;
import kr.ac.kaist.jsaf.nodes.WUnionType;
import kr.ac.kaist.jsaf.nodes_util.SpanInfo;

public class WNodeReader {
    protected BufferedReader in;
    protected char currentChar = (char)32;

    public static WNode read(String s) throws IOException {
        return WNodeReader.read(new StringReader(s));
    }

    public static WNode read(Reader r) throws IOException {
        return new WNodeReader(new BufferedReader(r)).readWNode();
    }

    protected WNodeReader(BufferedReader r) {
        this.in = r;
    }

    public WNode readWNode() throws IOException {
        String name = this.readWord();
        if (name.equals("_")) {
            return null;
        }
        if (name.equals("WModule:")) {
            return this.readWModuleBody();
        }
        if (name.equals("WInterface:")) {
            return this.readWInterfaceBody();
        }
        if (name.equals("WCallback:")) {
            return this.readWCallbackBody();
        }
        if (name.equals("WDictionary:")) {
            return this.readWDictionaryBody();
        }
        if (name.equals("WException:")) {
            return this.readWExceptionBody();
        }
        if (name.equals("WEnum:")) {
            return this.readWEnumBody();
        }
        if (name.equals("WTypedef:")) {
            return this.readWTypedefBody();
        }
        if (name.equals("WImplementsStatement:")) {
            return this.readWImplementsStatementBody();
        }
        if (name.equals("WConst:")) {
            return this.readWConstBody();
        }
        if (name.equals("WAttribute:")) {
            return this.readWAttributeBody();
        }
        if (name.equals("WOperation:")) {
            return this.readWOperationBody();
        }
        if (name.equals("WDictionaryMember:")) {
            return this.readWDictionaryMemberBody();
        }
        if (name.equals("WExceptionField:")) {
            return this.readWExceptionFieldBody();
        }
        if (name.equals("WBoolean:")) {
            return this.readWBooleanBody();
        }
        if (name.equals("WFloat:")) {
            return this.readWFloatBody();
        }
        if (name.equals("WInteger:")) {
            return this.readWIntegerBody();
        }
        if (name.equals("WString:")) {
            return this.readWStringBody();
        }
        if (name.equals("WNull:")) {
            return this.readWNullBody();
        }
        if (name.equals("WAnyType:")) {
            return this.readWAnyTypeBody();
        }
        if (name.equals("WNamedType:")) {
            return this.readWNamedTypeBody();
        }
        if (name.equals("WArrayType:")) {
            return this.readWArrayTypeBody();
        }
        if (name.equals("WSequenceType:")) {
            return this.readWSequenceTypeBody();
        }
        if (name.equals("WUnionType:")) {
            return this.readWUnionTypeBody();
        }
        if (name.equals("WArgument:")) {
            return this.readWArgumentBody();
        }
        if (name.equals("WId:")) {
            return this.readWIdBody();
        }
        if (name.equals("WQId:")) {
            return this.readWQIdBody();
        }
        if (name.equals("WTSArray:")) {
            return this.readWTSArrayBody();
        }
        if (name.equals("WTSQuestion:")) {
            return this.readWTSQuestionBody();
        }
        if (name.equals("WEAConstructor:")) {
            return this.readWEAConstructorBody();
        }
        if (name.equals("WEAArray:")) {
            return this.readWEAArrayBody();
        }
        if (name.equals("WEANoInterfaceObject:")) {
            return this.readWEANoInterfaceObjectBody();
        }
        if (name.equals("WEACallbackFunctionOnly:")) {
            return this.readWEACallbackFunctionOnlyBody();
        }
        if (name.equals("WEAString:")) {
            return this.readWEAStringBody();
        }
        if (name.equals("WEAQuestion:")) {
            return this.readWEAQuestionBody();
        }
        if (name.equals("WEAEllipsis:")) {
            return this.readWEAEllipsisBody();
        }
        if (name.equals("WEAOptional:")) {
            return this.readWEAOptionalBody();
        }
        if (name.equals("WEAAttribute:")) {
            return this.readWEAAttributeBody();
        }
        if (name.equals("WEACallback:")) {
            return this.readWEACallbackBody();
        }
        if (name.equals("WEAConst:")) {
            return this.readWEAConstBody();
        }
        if (name.equals("WEACreator:")) {
            return this.readWEACreatorBody();
        }
        if (name.equals("WEADeleter:")) {
            return this.readWEADeleterBody();
        }
        if (name.equals("WEADictionary:")) {
            return this.readWEADictionaryBody();
        }
        if (name.equals("WEAEnum:")) {
            return this.readWEAEnumBody();
        }
        if (name.equals("WEAException:")) {
            return this.readWEAExceptionBody();
        }
        if (name.equals("WEAGetter:")) {
            return this.readWEAGetterBody();
        }
        if (name.equals("WEAImplements:")) {
            return this.readWEAImplementsBody();
        }
        if (name.equals("WEAInherit:")) {
            return this.readWEAInheritBody();
        }
        if (name.equals("WEAInterface:")) {
            return this.readWEAInterfaceBody();
        }
        if (name.equals("WEAReadonly:")) {
            return this.readWEAReadonlyBody();
        }
        if (name.equals("WEALegacycaller:")) {
            return this.readWEALegacycallerBody();
        }
        if (name.equals("WEAPartial:")) {
            return this.readWEAPartialBody();
        }
        if (name.equals("WEASetter:")) {
            return this.readWEASetterBody();
        }
        if (name.equals("WEAStatic:")) {
            return this.readWEAStaticBody();
        }
        if (name.equals("WEAStringifier:")) {
            return this.readWEAStringifierBody();
        }
        if (name.equals("WEATypedef:")) {
            return this.readWEATypedefBody();
        }
        if (name.equals("WEAUnrestricted:")) {
            return this.readWEAUnrestrictedBody();
        }
        if (name.equals("WQStatic:")) {
            return this.readWQStaticBody();
        }
        if (name.equals("WQGetter:")) {
            return this.readWQGetterBody();
        }
        if (name.equals("WQSetter:")) {
            return this.readWQSetterBody();
        }
        if (name.equals("WQCreator:")) {
            return this.readWQCreatorBody();
        }
        if (name.equals("WQDeleter:")) {
            return this.readWQDeleterBody();
        }
        if (name.equals("WQLegacycaller:")) {
            return this.readWQLegacycallerBody();
        }
        throw this.error();
    }

    private WModule readWModuleBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("attrs = ");
        List<WEAttribute> read_attrs = this.readListOfWEAttribute();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        this.readFieldDelim("defs = ");
        List<WDefinition> read_defs = this.readListOfWDefinition();
        return new WModule(read_info, read_attrs, read_name, read_defs);
    }

    private WInterface readWInterfaceBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("attrs = ");
        List<WEAttribute> read_attrs = this.readListOfWEAttribute();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        this.readFieldDelim("parent = ");
        Option<WId> read_parent = this.readOptionOfWId();
        this.readFieldDelim("members = ");
        List<WInterfaceMember> read_members = this.readListOfWInterfaceMember();
        return new WInterface(read_info, read_attrs, read_name, read_parent, read_members);
    }

    private WCallback readWCallbackBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("attrs = ");
        List<WEAttribute> read_attrs = this.readListOfWEAttribute();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        this.readFieldDelim("returnType = ");
        WType read_returnType = (WType)this.readWNode();
        this.readFieldDelim("args = ");
        List<WArgument> read_args = this.readListOfWArgument();
        return new WCallback(read_info, read_attrs, read_name, read_returnType, read_args);
    }

    private WDictionary readWDictionaryBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("attrs = ");
        List<WEAttribute> read_attrs = this.readListOfWEAttribute();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        this.readFieldDelim("parent = ");
        Option<WId> read_parent = this.readOptionOfWId();
        this.readFieldDelim("members = ");
        List<WDictionaryMember> read_members = this.readListOfWDictionaryMember();
        return new WDictionary(read_info, read_attrs, read_name, read_parent, read_members);
    }

    private WException readWExceptionBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("attrs = ");
        List<WEAttribute> read_attrs = this.readListOfWEAttribute();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        this.readFieldDelim("parent = ");
        Option<WId> read_parent = this.readOptionOfWId();
        this.readFieldDelim("members = ");
        List<WExceptionMember> read_members = this.readListOfWExceptionMember();
        return new WException(read_info, read_attrs, read_name, read_parent, read_members);
    }

    private WEnum readWEnumBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("attrs = ");
        List<WEAttribute> read_attrs = this.readListOfWEAttribute();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        this.readFieldDelim("enumValueList = ");
        List<WString> read_enumValueList = this.readListOfWString();
        return new WEnum(read_info, read_attrs, read_name, read_enumValueList);
    }

    private WTypedef readWTypedefBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("attrs = ");
        List<WEAttribute> read_attrs = this.readListOfWEAttribute();
        this.readFieldDelim("typ = ");
        WType read_typ = (WType)this.readWNode();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        return new WTypedef(read_info, read_attrs, read_typ, read_name);
    }

    private WImplementsStatement readWImplementsStatementBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("attrs = ");
        List<WEAttribute> read_attrs = this.readListOfWEAttribute();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        this.readFieldDelim("parent = ");
        String read_parent = this.readString();
        return new WImplementsStatement(read_info, read_attrs, read_name, read_parent);
    }

    private WConst readWConstBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("attrs = ");
        List<WEAttribute> read_attrs = this.readListOfWEAttribute();
        this.readFieldDelim("typ = ");
        WType read_typ = (WType)this.readWNode();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        this.readFieldDelim("value = ");
        WLiteral read_value = (WLiteral)this.readWNode();
        return new WConst(read_info, read_attrs, read_typ, read_name, read_value);
    }

    private WAttribute readWAttributeBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("attrs = ");
        List<WEAttribute> read_attrs = this.readListOfWEAttribute();
        this.readFieldDelim("typ = ");
        WType read_typ = (WType)this.readWNode();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        this.readFieldDelim("exns = ");
        List<WQId> read_exns = this.readListOfWQId();
        return new WAttribute(read_info, read_attrs, read_typ, read_name, read_exns);
    }

    private WOperation readWOperationBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("attrs = ");
        List<WEAttribute> read_attrs = this.readListOfWEAttribute();
        this.readFieldDelim("qualifiers = ");
        List<WQualifier> read_qualifiers = this.readListOfWQualifier();
        this.readFieldDelim("typ = ");
        WType read_typ = (WType)this.readWNode();
        this.readFieldDelim("name = ");
        Option<String> read_name = this.readOptionOfString();
        this.readFieldDelim("args = ");
        List<WArgument> read_args = this.readListOfWArgument();
        this.readFieldDelim("exns = ");
        List<WQId> read_exns = this.readListOfWQId();
        return new WOperation(read_info, read_attrs, read_qualifiers, read_typ, read_name, read_args, read_exns);
    }

    private WDictionaryMember readWDictionaryMemberBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("attrs = ");
        List<WEAttribute> read_attrs = this.readListOfWEAttribute();
        this.readFieldDelim("typ = ");
        WType read_typ = (WType)this.readWNode();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        this.readFieldDelim("default = ");
        Option<WLiteral> read_default = this.readOptionOfWLiteral();
        return new WDictionaryMember(read_info, read_attrs, read_typ, read_name, read_default);
    }

    private WExceptionField readWExceptionFieldBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("attrs = ");
        List<WEAttribute> read_attrs = this.readListOfWEAttribute();
        this.readFieldDelim("typ = ");
        WType read_typ = (WType)this.readWNode();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        return new WExceptionField(read_info, read_attrs, read_typ, read_name);
    }

    private WBoolean readWBooleanBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("value = ");
        boolean read_value = this.readBoolean();
        return new WBoolean(read_info, read_value);
    }

    private WFloat readWFloatBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("value = ");
        String read_value = this.readString();
        return new WFloat(read_info, read_value);
    }

    private WInteger readWIntegerBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("value = ");
        String read_value = this.readString();
        return new WInteger(read_info, read_value);
    }

    private WString readWStringBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("str = ");
        String read_str = this.readString();
        return new WString(read_info, read_str);
    }

    private WNull readWNullBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        return new WNull(read_info);
    }

    private WAnyType readWAnyTypeBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("suffix = ");
        List<WTypeSuffix> read_suffix = this.readListOfWTypeSuffix();
        return new WAnyType(read_info, read_suffix);
    }

    private WNamedType readWNamedTypeBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("suffix = ");
        List<WTypeSuffix> read_suffix = this.readListOfWTypeSuffix();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        return new WNamedType(read_info, read_suffix, read_name);
    }

    private WArrayType readWArrayTypeBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("suffix = ");
        List<WTypeSuffix> read_suffix = this.readListOfWTypeSuffix();
        this.readFieldDelim("typ = ");
        WType read_typ = (WType)this.readWNode();
        return new WArrayType(read_info, read_suffix, read_typ);
    }

    private WSequenceType readWSequenceTypeBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("suffix = ");
        List<WTypeSuffix> read_suffix = this.readListOfWTypeSuffix();
        this.readFieldDelim("typ = ");
        WType read_typ = (WType)this.readWNode();
        return new WSequenceType(read_info, read_suffix, read_typ);
    }

    private WUnionType readWUnionTypeBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("suffix = ");
        List<WTypeSuffix> read_suffix = this.readListOfWTypeSuffix();
        this.readFieldDelim("types = ");
        List<WType> read_types = this.readListOfWType();
        return new WUnionType(read_info, read_suffix, read_types);
    }

    private WArgument readWArgumentBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("attributes = ");
        List<WEAttribute> read_attributes = this.readListOfWEAttribute();
        this.readFieldDelim("typ = ");
        WType read_typ = (WType)this.readWNode();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        this.readFieldDelim("default = ");
        Option<WLiteral> read_default = this.readOptionOfWLiteral();
        return new WArgument(read_info, read_attributes, read_typ, read_name, read_default);
    }

    private WId readWIdBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("name = ");
        String read_name = this.readString();
        return new WId(read_info, read_name);
    }

    private WQId readWQIdBody() throws IOException {
        this.readFieldDelim("info = ");
        SpanInfo read_info = (SpanInfo)this.readUnknownObject();
        this.readFieldDelim("name = ");
        List<String> read_name = this.readListOfString();
        return new WQId(read_info, read_name);
    }

    private WTSArray readWTSArrayBody() throws IOException {
        return new WTSArray();
    }

    private WTSQuestion readWTSQuestionBody() throws IOException {
        return new WTSQuestion();
    }

    private WEAConstructor readWEAConstructorBody() throws IOException {
        this.readFieldDelim("args = ");
        List<WArgument> read_args = this.readListOfWArgument();
        return new WEAConstructor(read_args);
    }

    private WEAArray readWEAArrayBody() throws IOException {
        return new WEAArray();
    }

    private WEANoInterfaceObject readWEANoInterfaceObjectBody() throws IOException {
        return new WEANoInterfaceObject();
    }

    private WEACallbackFunctionOnly readWEACallbackFunctionOnlyBody() throws IOException {
        return new WEACallbackFunctionOnly();
    }

    private WEAString readWEAStringBody() throws IOException {
        this.readFieldDelim("str = ");
        String read_str = this.readString();
        return new WEAString(read_str);
    }

    private WEAQuestion readWEAQuestionBody() throws IOException {
        return new WEAQuestion();
    }

    private WEAEllipsis readWEAEllipsisBody() throws IOException {
        return new WEAEllipsis();
    }

    private WEAOptional readWEAOptionalBody() throws IOException {
        return new WEAOptional();
    }

    private WEAAttribute readWEAAttributeBody() throws IOException {
        return new WEAAttribute();
    }

    private WEACallback readWEACallbackBody() throws IOException {
        return new WEACallback();
    }

    private WEAConst readWEAConstBody() throws IOException {
        return new WEAConst();
    }

    private WEACreator readWEACreatorBody() throws IOException {
        return new WEACreator();
    }

    private WEADeleter readWEADeleterBody() throws IOException {
        return new WEADeleter();
    }

    private WEADictionary readWEADictionaryBody() throws IOException {
        return new WEADictionary();
    }

    private WEAEnum readWEAEnumBody() throws IOException {
        return new WEAEnum();
    }

    private WEAException readWEAExceptionBody() throws IOException {
        return new WEAException();
    }

    private WEAGetter readWEAGetterBody() throws IOException {
        return new WEAGetter();
    }

    private WEAImplements readWEAImplementsBody() throws IOException {
        return new WEAImplements();
    }

    private WEAInherit readWEAInheritBody() throws IOException {
        return new WEAInherit();
    }

    private WEAInterface readWEAInterfaceBody() throws IOException {
        return new WEAInterface();
    }

    private WEAReadonly readWEAReadonlyBody() throws IOException {
        return new WEAReadonly();
    }

    private WEALegacycaller readWEALegacycallerBody() throws IOException {
        return new WEALegacycaller();
    }

    private WEAPartial readWEAPartialBody() throws IOException {
        return new WEAPartial();
    }

    private WEASetter readWEASetterBody() throws IOException {
        return new WEASetter();
    }

    private WEAStatic readWEAStaticBody() throws IOException {
        return new WEAStatic();
    }

    private WEAStringifier readWEAStringifierBody() throws IOException {
        return new WEAStringifier();
    }

    private WEATypedef readWEATypedefBody() throws IOException {
        return new WEATypedef();
    }

    private WEAUnrestricted readWEAUnrestrictedBody() throws IOException {
        return new WEAUnrestricted();
    }

    private WQStatic readWQStaticBody() throws IOException {
        return new WQStatic();
    }

    private WQGetter readWQGetterBody() throws IOException {
        return new WQGetter();
    }

    private WQSetter readWQSetterBody() throws IOException {
        return new WQSetter();
    }

    private WQCreator readWQCreatorBody() throws IOException {
        return new WQCreator();
    }

    private WQDeleter readWQDeleterBody() throws IOException {
        return new WQDeleter();
    }

    private WQLegacycaller readWQLegacycallerBody() throws IOException {
        return new WQLegacycaller();
    }

    private List<WEAttribute> readListOfWEAttribute() throws IOException {
        this.readExpected("{");
        ArrayList<WEAttribute> accum = new ArrayList<WEAttribute>();
        while (this.readMoreListElements()) {
            accum.add((WEAttribute)this.readWNode());
        }
        return accum;
    }

    private List<WDefinition> readListOfWDefinition() throws IOException {
        this.readExpected("{");
        ArrayList<WDefinition> accum = new ArrayList<WDefinition>();
        while (this.readMoreListElements()) {
            accum.add((WDefinition)this.readWNode());
        }
        return accum;
    }

    private Option<WId> readOptionOfWId() throws IOException {
        if (this.readOptionHeader()) {
            WId elt_result = (WId)this.readWNode();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    private List<WInterfaceMember> readListOfWInterfaceMember() throws IOException {
        this.readExpected("{");
        ArrayList<WInterfaceMember> accum = new ArrayList<WInterfaceMember>();
        while (this.readMoreListElements()) {
            accum.add((WInterfaceMember)this.readWNode());
        }
        return accum;
    }

    private List<WArgument> readListOfWArgument() throws IOException {
        this.readExpected("{");
        ArrayList<WArgument> accum = new ArrayList<WArgument>();
        while (this.readMoreListElements()) {
            accum.add((WArgument)this.readWNode());
        }
        return accum;
    }

    private List<WDictionaryMember> readListOfWDictionaryMember() throws IOException {
        this.readExpected("{");
        ArrayList<WDictionaryMember> accum = new ArrayList<WDictionaryMember>();
        while (this.readMoreListElements()) {
            accum.add((WDictionaryMember)this.readWNode());
        }
        return accum;
    }

    private List<WExceptionMember> readListOfWExceptionMember() throws IOException {
        this.readExpected("{");
        ArrayList<WExceptionMember> accum = new ArrayList<WExceptionMember>();
        while (this.readMoreListElements()) {
            accum.add((WExceptionMember)this.readWNode());
        }
        return accum;
    }

    private List<WString> readListOfWString() throws IOException {
        this.readExpected("{");
        ArrayList<WString> accum = new ArrayList<WString>();
        while (this.readMoreListElements()) {
            accum.add((WString)this.readWNode());
        }
        return accum;
    }

    private List<WQId> readListOfWQId() throws IOException {
        this.readExpected("{");
        ArrayList<WQId> accum = new ArrayList<WQId>();
        while (this.readMoreListElements()) {
            accum.add((WQId)this.readWNode());
        }
        return accum;
    }

    private List<WQualifier> readListOfWQualifier() throws IOException {
        this.readExpected("{");
        ArrayList<WQualifier> accum = new ArrayList<WQualifier>();
        while (this.readMoreListElements()) {
            accum.add((WQualifier)this.readWNode());
        }
        return accum;
    }

    private Option<String> readOptionOfString() throws IOException {
        if (this.readOptionHeader()) {
            String elt_result = this.readString();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    private Option<WLiteral> readOptionOfWLiteral() throws IOException {
        if (this.readOptionHeader()) {
            WLiteral elt_result = (WLiteral)this.readWNode();
            this.readExpected(")");
            return Option.some((Object)elt_result);
        }
        return Option.none();
    }

    private List<WTypeSuffix> readListOfWTypeSuffix() throws IOException {
        this.readExpected("{");
        ArrayList<WTypeSuffix> accum = new ArrayList<WTypeSuffix>();
        while (this.readMoreListElements()) {
            accum.add((WTypeSuffix)this.readWNode());
        }
        return accum;
    }

    private List<WType> readListOfWType() throws IOException {
        this.readExpected("{");
        ArrayList<WType> accum = new ArrayList<WType>();
        while (this.readMoreListElements()) {
            accum.add((WType)this.readWNode());
        }
        return accum;
    }

    private List<String> readListOfString() throws IOException {
        this.readExpected("{");
        ArrayList<String> accum = new ArrayList<String>();
        while (this.readMoreListElements()) {
            accum.add(this.readString());
        }
        return accum;
    }

    protected boolean readBoolean() throws IOException {
        char c;
        char t = c = this.readCharWord();
        while (!Character.isWhitespace(t)) {
            t = this.next();
        }
        if (c == 't') {
            return true;
        }
        if (c == 'f') {
            return false;
        }
        throw this.error();
    }

    protected char readChar() throws IOException {
        this.readExpected("\"");
        String word = this.readTo('\"', true);
        String result = this.unescape(word);
        if (result.length() != 1) {
            throw this.error();
        }
        return result.charAt(0);
    }

    protected byte readByte() throws IOException {
        String word = this.readNum();
        try {
            return Byte.parseByte(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected short readShort() throws IOException {
        String word = this.readNum();
        try {
            return Short.parseShort(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected int readInt() throws IOException {
        String word = this.readNum();
        try {
            return Integer.parseInt(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected long readLong() throws IOException {
        String word = this.readNum();
        try {
            return Long.parseLong(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected float readFloat() throws IOException {
        String word = this.readWord();
        try {
            return Float.parseFloat(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected double readDouble() throws IOException {
        String word = this.readWord();
        try {
            return Double.parseDouble(word);
        }
        catch (NumberFormatException e) {
            throw this.error();
        }
    }

    protected String readString() throws IOException {
        char delim = this.readCharWord();
        if (delim == '_') {
            return null;
        }
        if (delim != '\"') {
            throw this.error();
        }
        this.next();
        String word = this.readTo('\"', true);
        return this.unescape(word);
    }

    protected Object wordToUnknownObject(String word) throws IOException {
        if (word.equals("_")) {
            return null;
        }
        ObjectInputStream objIn = this.toObjectStream(word);
        try {
            Object object = objIn.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("ClassNotFoundException: " + e.getMessage());
        }
        finally {
            try {
                objIn.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected Object readUnknownObject() throws IOException {
        String word = this.readWord();
        this.readToNewline();
        return this.wordToUnknownObject(word);
    }

    protected String readWord() throws IOException {
        char c = this.readCharWord();
        StringBuilder result = new StringBuilder();
        do {
            result.append(c);
        } while (!Character.isWhitespace(c = this.next()));
        return result.toString();
    }

    protected String readNum() throws IOException {
        char c = this.readCharWord();
        StringBuilder result = new StringBuilder();
        if (c != '-' && !Character.isDigit(c)) {
            throw this.error();
        }
        do {
            result.append(c);
        } while (Character.isDigit(c = this.next()));
        return result.toString();
    }

    protected char readCharWord() throws IOException {
        char c = this.currentChar;
        while (Character.isWhitespace(c)) {
            c = this.next();
        }
        return c;
    }

    protected void readExpected(String s) throws IOException {
        char c = this.readCharWord();
        for (int i = 0; i < s.length(); ++i) {
            if (c != s.charAt(i)) {
                System.out.println("Was expecting '" + s + "', saw '" + c + "' instead of '" + s.charAt(i) + "'");
                throw this.error();
            }
            c = this.next();
        }
    }

    protected void readFieldDelim(String s) throws IOException {
        this.readExpected(s);
    }

    protected boolean readMoreListElements() throws IOException {
        char c = this.readCharWord();
        if (c == '}') {
            this.next();
            return false;
        }
        if (c == '*') {
            this.next();
            return true;
        }
        throw this.error();
    }

    protected boolean readOptionHeader() throws IOException {
        char c = this.readCharWord();
        if (c == '~') {
            this.next();
            return false;
        }
        if (c == '(') {
            this.next();
            return true;
        }
        throw this.error();
    }

    protected String readTo(char delim, boolean skipEscape) throws IOException {
        StringBuilder result = new StringBuilder();
        boolean escape2 = false;
        char c = this.curr();
        while (escape2 || c != delim) {
            if (c == '\n' || c == '\r') {
                throw this.error();
            }
            result.append(c);
            if (escape2) {
                escape2 = false;
            } else if (skipEscape && c == '\\') {
                escape2 = true;
            }
            c = this.next();
        }
        this.next();
        return result.toString();
    }

    protected char skipTo(char ... delims) throws IOException {
        char c = this.currentChar;
        while (true) {
            if (c == '\n' || c == '\r') {
                throw this.error();
            }
            for (char delim : delims) {
                if (c != delim) continue;
                return delim;
            }
            c = this.next();
        }
    }

    protected String readToNewline() throws IOException {
        String result = this.in.readLine();
        if (result == null) {
            throw this.error();
        }
        this.readCharWord();
        return result;
    }

    protected char next() throws IOException {
        int c = this.in.read();
        if (c == -1) {
            throw this.error();
        }
        this.currentChar = (char)c;
        return this.currentChar;
    }

    protected char curr() {
        return this.currentChar;
    }

    protected String unescape(String s) throws IOException {
        boolean escape2 = false;
        StringBuilder digits = new StringBuilder();
        boolean changed = false;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (escape2) {
                switch (c) {
                    case 'b': {
                        result.append('\b');
                        break;
                    }
                    case 't': {
                        result.append('\t');
                        break;
                    }
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case 'f': {
                        result.append('\f');
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        result.append(c);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        digits.append(c);
                        if (digits.length() != 3) break;
                        result.append((char)Integer.parseInt(digits.toString(), 8));
                        digits.setLength(0);
                        break;
                    }
                    default: {
                        throw this.error();
                    }
                }
                if (digits.length() != 0) continue;
                escape2 = false;
                continue;
            }
            if (c == '\\') {
                escape2 = true;
                changed = true;
                continue;
            }
            result.append(c);
        }
        if (escape2) {
            throw this.error();
        }
        return changed ? result.toString() : s;
    }

    protected ObjectInputStream toObjectStream(String byteString) throws IOException {
        if (byteString.length() % 2 != 0) {
            throw this.error();
        }
        int length2 = byteString.length() / 2;
        byte[] bytes = new byte[length2];
        for (int i = 0; i < length2; ++i) {
            String b = byteString.substring(i * 2, i * 2 + 2);
            try {
                int unsigned = Integer.parseInt(b, 16);
                if (unsigned < 128) {
                    bytes[i] = (byte)unsigned;
                    continue;
                }
                bytes[i] = (byte)(unsigned - 256);
                continue;
            }
            catch (NumberFormatException e) {
                throw this.error();
            }
        }
        return new ObjectInputStream(new ByteArrayInputStream(bytes));
    }

    protected IOException error() {
        return new IOException("Serialized data is not properly encoded");
    }
}

