//=--- TizenNativeAPIList.h - List of Native API's to track //
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
// List of Tizen Native API's
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_CLANG_SA_LIB_CHECKERS_TIZEN_API_LIST_H
#define LLVM_CLANG_SA_LIB_CHECKERS_TIZEN_API_LIST_H

namespace clang {
namespace ento {

/**
 * @brief The structure to track allocated/deallocated functions.
 */
struct TizenMemAPIMap {
  std::string allocatorFn;   /* Allocator function */
  int allocIndx;             /* Index of returned handle */
  std::string deAllocatorFn; /* Deallocator function */
};

// A List of Tizen API's for which we test Resource Leak issue.
// TODO: Hanlde more open/close type of mem leaks.

TizenMemAPIMap tizenMemAPIMap[] = {
  "messages_open_service",                  0, "messages_close_service",

  "messages_create_message",                1, "messages_destroy_message",
  "email_create_message",                   0, "email_destroy_message",
  "nfc_ndef_record_create",                 0, "nfc_ndef_record_destroy",
  "nfc_ndef_record_create_text",            0, "nfc_ndef_record_destroy",
  "nfc_ndef_message_create",                0, "nfc_ndef_message_destroy",
  "nfc_ndef_message_create_from_rawdata",   0, "nfc_ndef_message_destroy",
  "bt_adapter_le_create_advertiser",        0, "bt_adapter_le_destroy_advertiser",
  "bt_call_list_create" ,                   0, "bt_call_list_destroy",
  "account_create" ,                        0, "account_destroy",
  "account_type_create",                    0, "account_destroy",
  "metadata_extractor_create" ,             0, "metadata_extractor_destroy",
  "sound_manager_call_session_create",      1, "sound_manager_call_session_destroy",
  "sound_manager_multi_session_create",     1, "sound_manager_multi_session_destroy",
  "audio_in_create",                        3, "audio_in_destroy",
  "audio_out_create",                       4, "audio_out_destroy",
  "mediacodec_create",                      0, "mediacodec_destroy",
  "player_create",                          0, "player_destroy",
  "radio_create",                           0, "radio_destroy",
  "image_util_transform_create",            0, "image_util_transform_destroy",
  "video_util_create",                      0, "video_util_destroy",
  "camera_create",                          1, "camera_destroy",
  "recorder_create_videorecorder",          1, "recorder_destroy_videorecorde",
  "recorder_create_audiorecorder",          0, "recorder_destroy_audiorecorder",
  "video_wall_player_create",               0, "video_wall_player_destroy",
  "media_packet_create_alloc",              3, "media_packet_destroy",
  "media_packet_create",                    3, "media_packet_destroy",
  "media_packet_create_from_tbm_surface" ,  4, "media_packet_destroy",
  "i18n_timezone_create_unknown",           0, "i18n_timezone_destroy",
  "i18n_timezone_create_gmt",               0, "i18n_timezone_destroy",
  "i18n_timezone_create",                   0, "i18n_timezone_destroy",
  "i18n_timezone_create_default",           0, "i18n_timezone_destroy",
  "i18n_ucollator_create",                  1, "i18n_ucollator_destroy",
  "i18n_udate_create",                      7, "i18n_udate_destroy",
  "i18n_udatepg_create",                    1, "i18n_udatepg_destroy",
  "i18n_ucalendar_create",                  4, "i18n_ucalendar_destroy",
  "i18n_usearch_create",                    6, "i18n_usearch_destroy",
  "media_filter_create",                    0, "media_filter_destroy",
  "geocoder_create",                        0, "geocoder_destroy",
  "geocoder_preference_create",             0, "geocoder_preference_destroy",
  "poi_service_create",                     0, "poi_service_destroy",
  "poi_preference_create",                  0, "poi_preference_destroy",
  "poi_filter_create",                      0, "poi_filter_destroy",
  "poi_create",                             0, "poi_destroy",
  "maneuver_create",                        0, "maneuver_destroy",
  "sensor_create_listener",                 1, "sensor_destroy_listener",
  "activity_create",                        0, "activity_destroy",
  "gesture_create",                         0, "gesture_destroy",
  "package_manager_request_create",         0, "package_manager_request_destroy",
  "package_manager_create",                 0, "package_manager_destroy",
  "package_manager_filter_create",          0, "package_manager_filter_destroy",
  "package_info_create",                    1, "package_info_destroy",
  "app_info_create",                        1, "app_info_destroy",
  "app_info_filter_create",                 0, "app_info_filter_destroy",
  "app_info_metadata_filter_create",        0, "app_info_metadata_filter_destroy",
  "data_control_sql_create",                0, "data_control_sql_destroy",
  "app_control_create",                     0, "app_control_destroy",
  "data_control_map_create",                0, "data_control_map_destroy",
  "contacts_query_create",                  1, "contacts_query_destroy",
  "contacts_record_create",                 1, "contacts_record_destroy",
  "contacts_list_create",                   0, "contacts_list_destroy",
  "contacts_filter_create",                 1, "contacts_filter_destroy",
  "media_format_create",                    0, "media_format_dsetroy",
  "nfc_ndef_record_create_uri",             0, "nfc_ndef_record_destroy",
  "nfc_ndef_record_create_mime",            0, "nfc_ndef_record_destroy",
  "audio_in_create_loopback",               3, "audio_in_destroy",
  "audio_in_create_ex",                     3, "audio_in_destroy",
  "location_bounds_create_rect",            2, "location_bounds_destroy",
  "location_bounds_create_circle",          2, "location_bounds_destroy",
  "location_bounds_create_polygon",         3, "location_bounds_destroy",
  "location_manager_create",                1, "location_manager_destroy",
  "download_service_create",                0, "download_service_destroy",
  "route_service_create",                   0, "route_service_destroy",
  "route_preference_create",                0, "route_preference_destroy",
  "calendar_record_create",                 1, "calendar_record_destroy",
  "calendar_list_create",                   0, "calendar_list_destroy",
  "calendar_query_create",                  1, "calendar_query_destroy",
  "calendar_filter_create",                 1, "calendar_filter_destroy",

//clone API

  "privacy_info_clone",                     0, "privacy_info_destroy",
  "connection_profile_clone",               0, "connection_profile_destroy",
  "wifi_ap_clone",                          0, "wifi_ap_destroy",
  "contacts_record_clone",                  1, "contacts_record_destroy",
  "i18n_timezone_clone",                    1, "i18n_timezone_destroy",
  "media_playlist_clone",                   0, "media_playlist_destroy",
  "media_event_clone",                      0, "media_event_destroy",
  "video_meta_clone",                       0, "video_meta_destroy",
  "audio_meta_clone",                       0, "audio_meta_destroy",
  "media_bookmark_clone",                   0, "media_bookmark_destroy",
  "media_folder_clone",                     0, "media_folder_destroy",
  "media_category_clone",                   0, "media_category_destroy",
  "media_tag_clone",                        0, "media_tag_destroy",
  "media_album_clone",                      0, "media_album_destroy",
  "media_info_clone",                       0, "media_info_destroy",
  "poi_clone",                              0, "poi_destroy",
  "route_clone",                            0, "route_destroy",
  "route_segment_clone",                    0, "route_segment_destroy",
  "route_step_clone",                       0, "route_step_destroy",
  "maneuver_clone",                         0, "maneuver_destroy",
  "calendar_record_clone",                  1, "calendar_record_derstoy",
  "notification_clone",                     1, "notification_destroy",
  "app_context_clone",                      0, "app_context_destroy",
  "package_info_clone",                     0, "package_info_destroy",
  "app_info_clone",                         0, "app_info_destroy",
  "app_control_clone",                      0, "app_control_destroy"
};
}
}

#endif
