//===--- tools/APIChecker/APICheckerConsumer.h --------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
//  This file declares the ASTConsumer and Recursive Visitor for
//  APIChecker Tool
//
//===----------------------------------------------------------------------===//

/*
  APICheckerRecursiveVisitor
*/
#ifndef __AST_CHECKER_CONSUMER__
#define __AST_CHECKER_CONSUMER__

#include "clang/AST/ASTConsumer.h"
#include "clang/AST/Comment.h"
#include "clang/AST/RecursiveASTVisitor.h"
#include "clang/AST/ASTContext.h"
#include <unordered_map>
#include <fstream>

using namespace clang;
using namespace comments;

class APICheckerRecursiveVisitor
    : public RecursiveASTVisitor<APICheckerRecursiveVisitor> {
public:
  APICheckerRecursiveVisitor(ASTContext *Context, StringRef &infile)
      : AstContext(Context), infile(infile.str()) {}

  bool shouldVisitImplicitCode() const { return true; }
  bool VisitStmt(Stmt *S);
  bool VisitDecl(Decl *D);

private:
  ASTContext *AstContext;
  std::string infile;
};

/*
  APICheckerConsumer
*/
class APICheckerConsumer : public ASTConsumer {
public:
  APICheckerConsumer(ASTContext *Context, StringRef &infile)
      : Visitor(APICheckerRecursiveVisitor(Context, infile)) {}

  virtual bool HandleTopLevelDecl(DeclGroupRef DR);

private:
  APICheckerRecursiveVisitor Visitor;
};
#endif
