//===--- TizenToolChain.cpp - Tizen ToolChain Implementations -------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

#include "Tools.h"
#include "ToolChains.h"
#include "clang/Driver/Driver.h"
#include "llvm/Option/Arg.h"
#include "llvm/Option/ArgList.h"
#include "clang/Driver/Options.h"

using namespace clang;
using namespace clang::driver;
using namespace clang::driver::toolchains;
using namespace llvm::opt;

Tizen::Tizen(const Driver &D, const llvm::Triple &Triple, const ArgList &Args)
    : Linux(D, Triple, Args) {

  // tizen stores the gcc binary path to search gcc compiler.
  getProgramPaths().push_back(
      Twine(GCCInstallation.getParentLibPath() + "/../bin").str());
  // tizen stores the GccName with the compiler, add that to the search path.
  ToolChain::path_list &PPaths = getProgramPaths();
  PPaths.push_back(Twine(GCCInstallation.getParentLibPath() + "/../bin").str());
  std::string GccFileName(D.getCCCGenericGCCName());

#ifdef LLVM_ON_WIN32
  GccFileName += ".exe";
#endif

  GccName = GetProgramPath(GccFileName.c_str());
}

Tool *Tizen::buildAssembler() const {
  return new tools::tizen::Assemble(*this);
}

Tool *Tizen::buildLinker() const { return new tools::tizen::Link(*this); }

void Tizen::AddClangSystemIncludeArgs(const ArgList &DriverArgs,
                                      ArgStringList &CC1Args) const {
  Linux::AddClangSystemIncludeArgs(DriverArgs, CC1Args);
}
