#
# spec file for package python-beautifulsoup4
#
# Copyright (c) 2013 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


%define _name   beautifulsoup4
%define _major  4.x

Name:           python-%{_name}
Version:        4.1.3
Release:        3.1
Summary:        HTML/XML Parser for Quick-Turnaround Applications Like Screen-Scraping
License:        MIT
Group:          Development/Libraries/Python
Url:            http://www.crummy.com/software/BeautifulSoup/
Source:         http://pypi.python.org/packages/source/b/beautifulsoup4/beautifulsoup4-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
BuildRequires:  python-devel >= 2.6
BuildRequires:  python-nose
%{py_requires}

# build fails for SLE11 64bit due to 'noarch'
%if 0%{?suse_version} >= 1140
BuildArch:      noarch
%endif

%description
Beautiful Soup is a Python HTML/XML parser designed for quick turnaround
projects like screen-scraping. Three features make it powerful:

* Beautiful Soup won't choke if you give it bad markup. It yields a parse tree
  that makes approximately as much sense as your original document. This is
  usually good enough to collect the data you need and run away

* Beautiful Soup provides a few simple methods and Pythonic idioms for
  navigating, searching, and modifying a parse tree: a toolkit for dissecting a
  document and extracting what you need. You don't have to create a custom
  parser for each application

* Beautiful Soup automatically converts incoming documents to Unicode and
  outgoing documents to UTF-8. You don't have to think about encodings, unless
  the document doesn't specify an encoding and Beautiful Soup can't autodetect
  one. Then you just have to specify the original encoding

Beautiful Soup parses anything you give it, and does the tree traversal stuff
for you. You can tell it "Find all the links", or "Find all the links of class
externalLink", or "Find all the links whose urls match "foo.com", or "Find the
table heading that's got bold text, then give me that text."

Valuable data that was once locked up in poorly-designed websites is now within
your reach. Projects that would have taken hours take only minutes with
Beautiful Soup.


%prep
%setup -q -n %{_name}-%{version}

%build
export CFLAGS="%{optflags}"
python setup.py build

%install
python setup.py install                                                \
   --prefix=%{_prefix}                                                 \
   --root=%{buildroot}                                                 \
   --record-rpm=INSTALLED_FILES

%check
%if 0%{?suse_version} > 1210
nosetests
%endif

%files -f INSTALLED_FILES
%defattr(-,root,root)

%changelog
* Wed Jan  9 2013 cfarrell@suse.com
- license update: MIT
  See COPYING.txt
* Mon Sep 10 2012 nmo.marques@gmail.com
- initial package from version 4.1.3
  - based on spec file from python-beautifulsoup
  - requires python >= 2.6
