"""Tests for utils module."""

import unittest

from snapdiff import utils


class UtilsTestCase(unittest.TestCase):

    _multiprocess_can_split_ = True

    def test_xml2obj(self):
        """Ensures that we can properly parse xml to python objs"""
        repomd = """<?xml version="1.0" ?>
        <repomd>
          <revision>1385428310</revision>
          <data type="other_db">
            <location href="repodata/0b19c6c1677b8ab3f7-other.sqlite.bz2"/>
            <checksum type="sha256">06d90b19c6c1677b8ab3f7</checksum>
            <timestamp>1385428316.34</timestamp>
            <size>251882</size>
            <open-size>952320</open-size>
            <open-checksum type="sha256">71428390a3e9423abb</open-checksum>
            <database_version>10</database_version>
          </data>
          <data type="group">
            <location href="repodata/df569d7923ed3f60943449-group.xml.gz"/>
            <checksum type="sha256">df569d7923ed3f60943449</checksum>
            <timestamp>1385428350.75</timestamp>
            <open-checksum type="sha256">aab93a15ded699ffd46</open-checksum>
          </data>
        </repomd>
        """

        obj = utils.xml2obj(repomd)
        self.assertEqual(obj.revision, '1385428310')
        self.assertTrue(isinstance(obj['data'], list))
        self.assertEqual(obj['data'][0].size, '251882')
