
"""This module handles repo related"""

import gzip
import mimetypes
from StringIO import StringIO

import requests

from .utils import JsonDict, xml2obj


class RepoError(Exception):
    """Local custom Exception class, handle Repo Errors"""
    pass


def _get_primary_md(url):
    """Return xxx-primary.xml.gz's content"""
    repomd = _download(url + '/repodata/repomd.xml')

    if repomd is None:
        raise RepoError('Get repo: {0} metadata failed ...'.format(url))

    for item in xml2obj(repomd)['data']:
        if item.type == 'primary':
            href = item.location.href
            if href:
                return _download(url + '/' + href)

    raise RepoError('Get repo: {0} primary metadata failed ...'.format(url))

def _download(url):
    """Return given url's content"""
    # a very simple judgement :)
    if url.startswith('http') or url.startswith('https'):
        response = requests.get(url)

        if response.status_code == 200:
            if response.headers['content-type'] == 'application/x-gzip':
                gzf = gzip.GzipFile(fileobj=StringIO(response.content))
                return gzf.read()
            elif response.headers['content-type'] == 'text/xml' or response.headers['content-type'] == 'application/xml':
                return response.content
    else:
        # if url is a local path
        _type = mimetypes.guess_type(url)
        try:
            if _type[0] == 'text/xml' and _type[1] == 'gzip':
                with gzip.open(url) as gzf:
                    return gzf.read()
            elif _type[0] == 'text/xml' and _type[1] is None:
                with open(url, 'rb') as xml:
                    return xml.read()
        except IOError, err:
            print(err)


class Repo(object):
    """Stuff packages' info"""

    def __init__(self, url):
        self._primary = xml2obj(_get_primary_md(url))

    @property
    def packages(self):
        """Return a packages info dict"""
        packages_info = JsonDict()

        for package in self._primary.package:
            # vcs may be None, then give it a '#'.
            package.version.vcs = package.version.vcs or '#'
            if packages_info[package.name] is None:
                setattr(packages_info, package.name, [package])
            else:
                packages_info[package.name].append(package)

        return packages_info
